/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.banner_editor;

import fzmm.zailer.me.builders.BannerBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.banner_editor.tabs.AddPatternTab;
import fzmm.zailer.me.client.gui.banner_editor.tabs.ChangeColorTab;
import fzmm.zailer.me.client.gui.banner_editor.tabs.IBannerTab;
import fzmm.zailer.me.client.gui.banner_editor.tabs.RemovePatternTab;
import fzmm.zailer.me.client.gui.components.extend.EContainers;
import fzmm.zailer.me.client.gui.components.extend.component.EBooleanButton;
import fzmm.zailer.me.client.gui.components.extend.component.EButtonComponent;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.utils.select_item.RequestedItem;
import fzmm.zailer.me.client.gui.utils.select_item.SelectItemScreen;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.ItemUtils;
import fzmm.zailer.me.utils.history.HistoryClipboard;
import fzmm.zailer.me.utils.history.IClipboardState;
import io.wispforest.owo.ui.component.BoxComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class BannerEditorScreen
extends BaseFzmmScreen {
    private static IBannerTab selectedTab = new AddPatternTab();
    private ItemComponent bannerPreview;
    private EBooleanButton isShieldButton;
    private EFlowLayout contentLayout;
    private BannerBuilder bannerBuilder;
    private class_1767 selectedColor;
    private HistoryClipboard clipboard;

    public BannerEditorScreen(@Nullable class_437 parent) {
        super("banner_editor", "bannerEditor", parent);
    }

    @Override
    protected void setup(EFlowLayout rootComponent) {
        class_1767[] dyeColorsInOrder;
        this.bannerPreview = rootComponent.childByIdOrThrow(ItemComponent.class, "banner-preview");
        this.bannerBuilder = BannerBuilder.of(class_1802.field_8539.method_7854());
        rootComponent.childByIdOrThrow(ButtonComponent.class, "give-button").onPress(button -> ItemUtils.give(this.bannerBuilder.get()));
        rootComponent.childByIdOrThrow(ButtonComponent.class, "select-banner-button").onPress(button -> this.selectBanner());
        EButtonComponent undoButton = rootComponent.childByIdOrThrow(EButtonComponent.class, "undo-button");
        EButtonComponent redoButton = rootComponent.childByIdOrThrow(EButtonComponent.class, "redo-button");
        this.clipboard = new HistoryClipboard(this.bannerBuilder, undoButton, redoButton, FzmmClient.CONFIG.itemEditorBanner.maxUndo());
        this.clipboard.onChange(this::updatePreview);
        rootComponent.childByIdOrThrow(ButtonComponent.class, "clear-button").onPress(button -> this.clearBanner());
        FlowLayout colorLayout = rootComponent.childByIdOrThrow(FlowLayout.class, "color-layout");
        ArrayList<EFlowLayout> colorList = new ArrayList<EFlowLayout>();
        for (class_1767 class_17672 : dyeColorsInOrder = FzmmUtils.getDyeColorsInOrder()) {
            BoxComponent colorBox = Components.box((Sizing)Sizing.fixed((int)16), (Sizing)Sizing.fixed((int)16));
            colorBox.margins(Insets.of((int)1));
            colorBox.color(Color.ofDye((class_1767)class_17672));
            colorBox.fill(true);
            colorBox.cursorStyle(CursorStyle.HAND);
            EFlowLayout colorSelectedLayout = EContainers.horizontalFlow(Sizing.fixed((int)18), Sizing.fixed((int)18));
            colorSelectedLayout.padding(Insets.of((int)1));
            colorSelectedLayout.alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
            colorBox.mouseDown().subscribe((mouseX, mouseY, button) -> {
                this.selectedColor = dyeColor;
                this.updatePreview(this.bannerBuilder);
                for (Component component : colorList) {
                    if (!(component instanceof FlowLayout)) continue;
                    FlowLayout layout = (FlowLayout)component;
                    layout.surface(Surface.BLANK);
                }
                colorSelectedLayout.surface(Surface.outline((int)-1));
                return true;
            });
            colorSelectedLayout.child((Component)colorBox);
            colorList.add(colorSelectedLayout);
        }
        this.selectedColor = dyeColorsInOrder[0];
        colorLayout.children(colorList);
        this.contentLayout = rootComponent.childByIdOrThrow(EFlowLayout.class, "content");
        List<RemovePatternTab> tabs = List.of(new AddPatternTab(), new ChangeColorTab(), new RemovePatternTab());
        ArrayList<ButtonComponent> tabButtons = new ArrayList<ButtonComponent>();
        for (IBannerTab iBannerTab : tabs) {
            ButtonComponent button2 = rootComponent.childByIdOrThrow(ButtonComponent.class, iBannerTab.buttonId());
            button2.active(!iBannerTab.buttonId().equals(selectedTab.buttonId()));
            tabButtons.add(button2);
            button2.onPress(buttonComponent -> {
                for (ButtonComponent tabButton : tabButtons) {
                    tabButton.active(true);
                }
                button2.active(false);
                selectedTab = tab;
                this.updatePreview(this.bannerBuilder);
            });
        }
        this.isShieldButton = rootComponent.childByIdOrThrow(EBooleanButton.class, "is-shield");
        this.isShieldButton.enabled(false);
        this.isShieldButton.onPress(button -> this.isShieldButtonExecute(this.isShieldButton.enabled()));
        this.clipboard.clearUndo();
        this.updatePreview(this.bannerBuilder);
    }

    private void selectBanner() {
        ArrayList<class_1799> defaultItems = new ArrayList<class_1799>();
        for (class_1767 dye : FzmmUtils.getDyeColorsInOrder()) {
            defaultItems.add(BannerBuilder.getBannerByDye(dye).method_7854());
        }
        defaultItems.add(class_1802.field_8255.method_7854());
        RequestedItem requestedItem = new RequestedItem(itemStack -> itemStack.method_7909() instanceof class_1819 || itemStack.method_7909() instanceof class_1746, itemStack -> {
            if (itemStack.method_7960()) {
                return;
            }
            boolean isShield = itemStack.method_7909() instanceof class_1819;
            if (this.isShieldButton.enabled() != isShield) {
                this.isShieldButton.method_25306();
            }
            this.clipboard.addUndo(this.bannerBuilder);
            this.bannerBuilder = BannerBuilder.of(itemStack);
            this.updatePreview(this.bannerBuilder);
        }, defaultItems, this.bannerBuilder.get(), (class_2561)class_2561.method_43471((String)"fzmm.gui.bannerEditor.option.select.title"), true);
        assert (this.field_22787 != null);
        this.setScreen((class_437)new SelectItemScreen((class_437)this, requestedItem));
    }

    public void updatePreview(IClipboardState state) {
        BannerBuilder builder = (BannerBuilder)state;
        this.isShieldButton.enabledIgnoreCallback(builder.isShield());
        this.updatePreview(builder);
    }

    private void updatePreview(BannerBuilder builder) {
        this.bannerBuilder = builder;
        this.bannerPreview.stack(builder.get());
        List<Component> banners = selectedTab.update(this.clipboard, builder, this.selectedColor);
        this.contentLayout.configure(layout -> {
            layout.clearChildren();
            layout.children(banners);
        });
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.clipboard.keyPressed(keyCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void isShieldButtonExecute(boolean value) {
        this.isShieldButton.enabledIgnoreCallback(value);
        this.updatePreview(this.bannerBuilder.isShield(value));
    }

    private void clearBanner() {
        this.clipboard.addUndo(this.bannerBuilder);
        this.updatePreview(this.bannerBuilder.clearPatterns());
    }
}

