/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.banner_editor.tabs;

import fzmm.zailer.me.builders.BannerBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.banner_editor.tabs.IBannerTab;
import fzmm.zailer.me.client.gui.components.extend.EComponents;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.history.HistoryClipboard;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.util.UISounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2582;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7446;
import net.minecraft.class_7924;
import net.minecraft.class_9307;

public class AddPatternTab
implements IBannerTab {
    @Override
    public String buttonId() {
        return "add-pattern";
    }

    @Override
    public List<Component> update(HistoryClipboard clipboard, BannerBuilder currentBanner, class_1767 color) {
        ArrayList<Component> bannerList = new ArrayList<Component>();
        class_5455 registryManager = FzmmUtils.getRegistryManager();
        class_2378 bannerRegistry = registryManager.method_30530(class_7924.field_41252);
        Optional basePatternOptional = bannerRegistry.method_40264(class_7446.field_39151);
        if (basePatternOptional.isEmpty()) {
            FzmmClient.LOGGER.error("[AddPatternsTab] base pattern is null");
            return bannerList;
        }
        class_6880.class_6883 basePattern = (class_6880.class_6883)basePatternOptional.get();
        for (class_6880.class_6883 pattern : bannerRegistry.method_40270().toList()) {
            if (basePattern == pattern) continue;
            class_1799 banner = currentBanner.copy().addLayer(color, (class_6880<class_2582>)pattern).get();
            Component itemComponent = EComponents.item(banner).sizing(Sizing.fixed((int)32), Sizing.fixed((int)32)).tooltip(BannerBuilder.tooltipOf(new class_9307.class_9308((class_6880)pattern, color)));
            itemComponent.mouseDown().subscribe((mouseX, mouseY, button) -> {
                UISounds.playButtonSound();
                clipboard.addUndo(currentBanner);
                currentBanner.addLayer(color, (class_6880<class_2582>)pattern);
                clipboard.change(currentBanner);
                return true;
            });
            itemComponent.cursorStyle(CursorStyle.HAND);
            bannerList.add(itemComponent);
        }
        return bannerList;
    }
}

