/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.image;

import fzmm.zailer.me.client.gui.components.image.source.IImageGetter;
import fzmm.zailer.me.client.gui.components.image.source.ImageFileDialogSource;
import fzmm.zailer.me.client.gui.components.image.source.ImagePlayerNameSource;
import fzmm.zailer.me.client.gui.components.image.source.ImageUrlSource;
import fzmm.zailer.me.client.gui.components.image.source.PlayerHeadSource;
import fzmm.zailer.me.client.gui.components.image.source.ScreenshotSource;
import java.util.function.Supplier;

public enum ImageMode {
    URL("url", ImageUrlSource::new, false),
    SCREENSHOT("screenshot", ScreenshotSource::new, false),
    FILE_DIALOG("fileDialog", ImageFileDialogSource::new, false),
    NAME("name", ImagePlayerNameSource::new, true),
    HEAD("head", PlayerHeadSource::new, false);

    private static final String BASE_TRANSLATION_KEY = "fzmm.gui.option.image.";
    private final String id;
    private final Supplier<IImageGetter> sourceTypeSupplier;
    private final boolean isHeadName;

    private ImageMode(String id, Supplier<IImageGetter> sourceTypeSupplier, boolean isHeadName) {
        this.id = id;
        this.sourceTypeSupplier = sourceTypeSupplier;
        this.isHeadName = isHeadName;
    }

    public String getTranslationKey() {
        return BASE_TRANSLATION_KEY + this.id;
    }

    public IImageGetter getImageGetter() {
        return this.sourceTypeSupplier.get();
    }

    public boolean isHeadName() {
        return this.isHeadName;
    }
}

