/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.image.source;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.image.source.IInteractiveImageLoader;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.class_156;
import net.minecraft.class_310;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class ImageFileDialogSource
implements IInteractiveImageLoader {
    private BufferedImage image;

    @Override
    public void execute(Consumer<BufferedImage> consumer) {
        if (this.image != null) {
            this.image.flush();
        }
        this.image = null;
        CompletableFuture.runAsync(() -> {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer filterPatterns = stack.mallocPointer(5);
                filterPatterns.put(stack.UTF8((CharSequence)"*.jpg")).put(stack.UTF8((CharSequence)"*.jpeg")).put(stack.UTF8((CharSequence)"*.png")).put(stack.UTF8((CharSequence)"*.gif")).put(stack.UTF8((CharSequence)"*.bmp"));
                filterPatterns.flip();
                String imagePath = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Choose image file", null, (PointerBuffer)filterPatterns, (CharSequence)"Image files (JPG, PNG, GIF, BMP)", (boolean)false);
                if (imagePath != null) {
                    this.readImage(Path.of(imagePath, new String[0]));
                }
            }
            class_310.method_1551().execute(() -> consumer.accept(this.image));
        }, class_156.method_18349());
    }

    private void readImage(Path path) {
        File file = path.toFile();
        try {
            this.image = ImageIO.read(file);
        }
        catch (IOException e) {
            FzmmClient.LOGGER.error("[ImageFileSource] Failed to read image: {}", (Object)file.getAbsolutePath(), (Object)e);
        }
    }

    @Override
    public Optional<BufferedImage> getImage() {
        return Optional.ofNullable(this.image);
    }

    @Override
    public boolean hasTextField() {
        return false;
    }
}

