/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.row;

import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.row.AbstractRow;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class ConfigTextBoxRow
extends AbstractRow {
    public ConfigTextBoxRow(String baseTranslationKey, String id, String tooltipId) {
        super(baseTranslationKey, id, tooltipId, true);
    }

    @Override
    public Component[] getComponents(String id, String tooltipId) {
        Component configTextBox = new ConfigTextBox().horizontalSizing(Sizing.fixed((int)199)).id(ConfigTextBoxRow.getConfigTextBoxId(id));
        return new Component[]{configTextBox};
    }

    public static String getConfigTextBoxId(String id) {
        return id + "-text-box";
    }

    public static ConfigTextBox setup(EFlowLayout rootComponent, String id, String defaultValue) {
        return ConfigTextBoxRow.setup(rootComponent, ConfigTextBoxRow.getConfigTextBoxId(id), id, defaultValue, null);
    }

    public static ConfigTextBox setup(EFlowLayout rootComponent, String textBoxId, String id, String defaultValue, @Nullable Consumer<String> changedListener) {
        return ConfigTextBoxRow.setup(rootComponent, textBoxId, id, defaultValue, changedListener, defaultValue::equals);
    }

    public static ConfigTextBox setup(EFlowLayout rootComponent, String textBoxId, String id, String defaultValue, @Nullable Consumer<String> changedListener, Predicate<String> defaultPredicate) {
        ConfigTextBox textBox = rootComponent.childByIdOrThrow(ConfigTextBox.class, textBoxId);
        ButtonComponent resetButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, ConfigTextBoxRow.getResetButtonId(id));
        textBox.text(defaultValue);
        textBox.onChanged().subscribe(s -> {
            if (resetButton != null) {
                boolean bl = resetButton.field_22763 = !defaultPredicate.test(s);
            }
            if (changedListener != null) {
                changedListener.accept(s);
            }
        });
        if (resetButton != null) {
            resetButton.onPress(button -> textBox.text(defaultValue));
        }
        return textBox;
    }

    public static ConfigTextBoxRow parse(Element element) {
        String baseTranslationKey = BaseFzmmScreen.getBaseTranslationKey(element);
        String id = ConfigTextBoxRow.getId(element);
        String tooltipId = ConfigTextBoxRow.getTooltipId(element, id);
        return new ConfigTextBoxRow(baseTranslationKey, id, tooltipId);
    }
}

