/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.row;

import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.row.AbstractRow;
import fzmm.zailer.me.client.gui.components.row.ConfigTextBoxRow;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.util.NumberReflection;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class NumberRow
extends AbstractRow {
    public NumberRow(String baseTranslationKey, String id, String tooltipId) {
        super(baseTranslationKey, id, tooltipId, true);
    }

    @Override
    public Component[] getComponents(String id, String tooltipId) {
        Component numberField = new ConfigTextBox().horizontalSizing(Sizing.fixed((int)199)).id(NumberRow.getNumberFieldId(id));
        return new Component[]{numberField};
    }

    public static String getNumberFieldId(String id) {
        return id + "-number-field";
    }

    public static ConfigTextBox setup(EFlowLayout rootComponent, String id, double defaultValue, Class<? extends Number> numberType) {
        return NumberRow.setup(rootComponent, id, defaultValue, numberType, null);
    }

    public static ConfigTextBox setup(EFlowLayout rootComponent, String id, double defaultValue, Class<? extends Number> numberType, @Nullable Consumer<String> changedListener) {
        String defaultValueString = NumberReflection.isFloatingPointType(numberType) ? String.valueOf(defaultValue) : String.valueOf((int)defaultValue);
        ConfigTextBox numberBox = ConfigTextBoxRow.setup(rootComponent, NumberRow.getNumberFieldId(id), id, defaultValueString, changedListener, s -> {
            try {
                return !s.isBlank() && defaultValue == Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        numberBox.configureForNumber(numberType);
        return numberBox;
    }

    public static NumberRow parse(Element element) {
        String baseTranslationKey = BaseFzmmScreen.getBaseTranslationKey(element);
        String id = NumberRow.getId(element);
        String tooltipId = NumberRow.getTooltipId(element, id);
        return new NumberRow(baseTranslationKey, id, tooltipId);
    }
}

