/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.imagetext.algorithms;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.SuggestionTextBox;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.row.TextBoxRow;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.utils.TextUtils;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_437;

public class ImagetextCharactersAlgorithm
implements IImagetextAlgorithm {
    private static final String CHARACTERS_ID = "characters";
    private SuggestionTextBox charactersTextField;
    private BufferedImage image = null;
    private String[] palette = null;

    @Override
    public BufferedImage image() {
        return this.image;
    }

    @Override
    public void image(BufferedImage image) {
        this.image = image;
    }

    @Override
    public void build() {
        this.updatePalette();
    }

    private void updatePalette() {
        String palette = this.sanitize(this.charactersTextField.method_1882());
        this.palette = TextUtils.splitMessage(palette).toArray(new String[0]);
    }

    private String sanitize(String value) {
        return value.isBlank() ? "\u2588" : value;
    }

    @Override
    public String getId() {
        return CHARACTERS_ID;
    }

    @Override
    public String[] linePixels(int line) {
        return this.palette;
    }

    @Override
    public String pixelExample() {
        return this.sanitize(this.charactersTextField.method_1882());
    }

    @Override
    public float widthRatio() {
        return 1.0f;
    }

    @Override
    public float heightRatio() {
        return 1.0f;
    }

    @Override
    public void setUpdatePreviewCallback(Runnable callback) {
        this.charactersTextField.onChanged().subscribe(value -> callback.run());
    }

    @Override
    public void setupComponents(EFlowLayout rootComponent) {
        this.charactersTextField = (SuggestionTextBox)TextBoxRow.setup(rootComponent, CHARACTERS_ID, "\u2588", FzmmClient.CONFIG.imagetext.maxResolution());
        this.charactersTextField.method_1870(false);
        this.charactersTextField.setSuggestionProvider((nul, builder) -> {
            if (builder.getInput().isBlank()) {
                List<String> suggestions = List.of("\u2588", "\u258e", "\u258b", "\u2610", "\ud83c\udf11");
                for (String suggestion : suggestions) {
                    builder.suggest(suggestion);
                }
            }
            return CompletableFuture.completedFuture(builder.build());
        });
        this.charactersTextField.enableFontProcess(true);
        FlowLayout parentLayout = rootComponent.childByIdOrThrow(FlowLayout.class, TextBoxRow.getTextBoxId(CHARACTERS_ID) + "-parent");
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof BaseFzmmScreen) {
            BaseFzmmScreen baseScreen = (BaseFzmmScreen)class_4372;
            parentLayout.removeChild((Component)this.charactersTextField);
            List<Component> buttons = baseScreen.getSymbolChatCompat().getButtons(baseScreen, (class_342)this.charactersTextField);
            for (Component button : buttons) {
                button.sizing(Sizing.fixed((int)16));
            }
            parentLayout.children(buttons);
            parentLayout.child((Component)this.charactersTextField);
        }
    }

    @Override
    public void backup(ObjectOutputStream output) throws IOException {
        output.writeObject(this.charactersTextField.method_1882());
    }

    @Override
    public void restore(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.charactersTextField.text((String)input.readObject());
    }
}

