/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.main;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.FzmmIcons;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.HistoryScreen;
import fzmm.zailer.me.client.gui.banner_editor.BannerEditorScreen;
import fzmm.zailer.me.client.gui.components.extend.component.EButtonComponent;
import fzmm.zailer.me.client.gui.components.extend.component.ELabelComponent;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.converters.ConvertersScreen;
import fzmm.zailer.me.client.gui.encrypt_book.EncryptBookScreen;
import fzmm.zailer.me.client.gui.head_gallery.HeadGalleryScreen;
import fzmm.zailer.me.client.gui.head_generator.HeadGeneratorScreen;
import fzmm.zailer.me.client.gui.imagetext.ImagetextScreen;
import fzmm.zailer.me.client.gui.player_statue.PlayerStatueScreen;
import fzmm.zailer.me.client.gui.text_format.TextFormatScreen;
import fzmm.zailer.me.client.logic.history.FzmmHistory;
import fzmm.zailer.me.utils.HoverAnimationState;
import io.wispforest.owo.config.ConfigWrapper;
import io.wispforest.owo.config.ui.ConfigScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.StackLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class MainScreen
extends BaseFzmmScreen {
    private final HashMap<String, ButtonData> entries = this.getEntries();
    private ELabelComponent hoveredLabel;

    public MainScreen(@Nullable class_437 parent) {
        super("main", "main", parent);
    }

    private HashMap<String, ButtonData> getEntries() {
        LinkedHashMap<String, ButtonData> result = new LinkedHashMap<String, ButtonData>();
        result.put("imagetext", new ButtonData(ImagetextScreen::new, FzmmIcons.IMAGETEXT));
        result.put("textFormat", new ButtonData(TextFormatScreen::new, FzmmIcons.TEXT_FORMAT));
        result.put("playerStatue", new ButtonData(PlayerStatueScreen::new, FzmmIcons.PLAYER_STATUE));
        result.put("encryptbook", new ButtonData(EncryptBookScreen::new, FzmmIcons.ENCRYPT_BOOK));
        result.put("headGenerator", new ButtonData(HeadGeneratorScreen::new, FzmmIcons.HEAD_GENERATOR));
        result.put("converters", new ButtonData(ConvertersScreen::new, FzmmIcons.CONVERTERS));
        result.put("history", new ButtonData(HistoryScreen::new, FzmmIcons.HISTORY, !FzmmHistory.getAllItems().isEmpty()));
        result.put("headGallery", new ButtonData(HeadGalleryScreen::new, FzmmIcons.HEAD_GALLERY));
        result.put("bannerEditor", new ButtonData(BannerEditorScreen::new, FzmmIcons.BANNER_EDITOR));
        return result;
    }

    @Override
    protected void setup(EFlowLayout rootComponent) {
        rootComponent.childByIdOrThrow(ButtonComponent.class, "config-button").onPress(button -> this.field_22787.method_1507((class_437)ConfigScreen.create((ConfigWrapper)FzmmClient.CONFIG, (class_437)this)));
        this.hoveredLabel = rootComponent.childByIdOrThrow(ELabelComponent.class, "hovered");
        ArrayList<StackLayout> entryLayoutList = new ArrayList<StackLayout>();
        for (String id : this.entries.keySet()) {
            ButtonData entry = this.entries.get(id);
            StackLayout buttonLayout = (StackLayout)this.getModel().expandTemplate(StackLayout.class, "main-button-layout", Map.of("name", id, "u", String.valueOf(entry.u()), "v", String.valueOf(entry.v())));
            EButtonComponent button2 = (EButtonComponent)buttonLayout.childById(EButtonComponent.class, id);
            assert (button2 != null);
            button2.active(entry.enabled());
            button2.mouseEnter().subscribe(() -> this.selectEntry(button2));
            button2.focusGained().subscribe(focusSource -> this.selectEntry(button2));
            button2.mouseLeave().subscribe(() -> this.unselectEntry(button2));
            button2.focusLost().subscribe(() -> this.unselectEntry(button2));
            button2.onPress(buttonComponent -> this.setScreen(entry.screenGetter().apply(this)));
            button2.renderer(this.buttonRenderer());
            entryLayoutList.add(buttonLayout);
        }
        rootComponent.childByIdOrThrow(FlowLayout.class, "content").children(entryLayoutList);
    }

    private void selectEntry(EButtonComponent button) {
        this.hoveredLabel.text(this.buttonText(button.id()));
    }

    private void unselectEntry(EButtonComponent button) {
        if (this.hoveredLabel.text().equals((Object)this.buttonText(button.id()))) {
            this.hoveredLabel.text((class_2561)class_2561.method_43473());
        }
    }

    private class_2561 buttonText(String id) {
        return class_2561.method_43471((String)("fzmm.gui.title." + id));
    }

    private ButtonComponent.Renderer buttonRenderer() {
        HoverAnimationState animationState = new HoverAnimationState(0.8f);
        return (context, button, delta) -> {
            int borderColor;
            boolean isHovered = button.method_49606() && button.active();
            double progress = animationState.update(isHovered);
            int alpha = class_3532.method_15340((int)((int)(progress * 255.0)), (int)128, (int)255);
            int n = borderColor = isHovered ? -1 : -12163513;
            if (button.active()) {
                int background = 0x479E4A | alpha << 24;
                context.method_25294(button.x(), button.y(), button.x() + button.width(), button.y() + button.height(), background);
            }
            context.method_49601(button.x(), button.y(), button.width(), button.height(), borderColor);
        };
    }

    private record ButtonData(int u, int v, Function<MainScreen, class_437> screenGetter, boolean enabled) {
        public ButtonData(Function<MainScreen, class_437> screenGetter, int[] icon) {
            this(screenGetter, icon, true);
        }

        public ButtonData(Function<MainScreen, class_437> screenGetter, int[] icon, boolean enabled) {
            this(icon[0], icon[1], screenGetter, enabled);
        }
    }
}

