/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.text_format.tabs;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.SliderWidget;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.components.row.SliderRow;
import fzmm.zailer.me.client.gui.text_format.tabs.ITextFormatTab;
import fzmm.zailer.me.client.logic.TextFormatLogic;
import fzmm.zailer.me.client.logic.history.IMemento;
import fzmm.zailer.me.config.FzmmConfig;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.class_2561;

public class TextFormatRainbowTab
implements ITextFormatTab,
IMemento {
    private SliderWidget hue;
    private SliderWidget brightness;
    private SliderWidget saturation;
    private SliderWidget hueStep;

    @Override
    public String getId() {
        return "rainbow";
    }

    @Override
    public class_2561 getText(TextFormatLogic logic) {
        float hue = ((Float)this.hue.parsedValue()).floatValue();
        float saturation = ((Float)this.saturation.parsedValue()).floatValue();
        float brightness = ((Float)this.brightness.parsedValue()).floatValue();
        float hueStep = ((Float)this.hueStep.parsedValue()).floatValue();
        return logic.getRainbow(hue, saturation, brightness, hueStep);
    }

    @Override
    public void setupComponents(EFlowLayout rootComponent) {
        FzmmConfig.TextFormat config = FzmmClient.CONFIG.textFormat;
        this.hue = SliderRow.setup(rootComponent, "hue", 1.0, 0.0, 1.0, Float.class, 3, 0.025, d -> {});
        this.brightness = SliderRow.setup(rootComponent, "brightness", 0.8, 0.0, 1.0, Float.class, 3, 0.025, d -> {});
        this.saturation = SliderRow.setup(rootComponent, "saturation", 1.0, 0.0, 1.0, Float.class, 3, 0.025, d -> {});
        this.hueStep = SliderRow.setup(rootComponent, "hueStep", 0.05, config.minRainbowHueStep(), config.maxRainbowHueStep(), Float.class, 3, 0.005, d -> {});
    }

    @Override
    public void setRandomValues() {
        FzmmConfig.TextFormat config = FzmmClient.CONFIG.textFormat;
        Random random = new Random(new Date().getTime());
        float hue = random.nextFloat();
        float saturation = random.nextFloat();
        float brightness = random.nextFloat();
        float hueStep = random.nextFloat(config.minRainbowHueStep(), config.maxRainbowHueStep());
        this.hue.setFromDiscreteValue(hue);
        this.saturation.setFromDiscreteValue(saturation);
        this.brightness.setFromDiscreteValue(brightness);
        this.hueStep.setFromDiscreteValue(hueStep);
    }

    @Override
    public void componentsCallback(Consumer<Object> callback) {
        this.hue.onChanged().subscribe(callback::accept);
        this.saturation.onChanged().subscribe(callback::accept);
        this.brightness.onChanged().subscribe(callback::accept);
        this.hueStep.onChanged().subscribe(callback::accept);
    }

    @Override
    public boolean hasStyles() {
        return true;
    }

    @Override
    public void backup(ObjectOutputStream output) throws IOException {
        output.writeFloat(((Float)this.hue.parsedValue()).floatValue());
        output.writeFloat(((Float)this.saturation.parsedValue()).floatValue());
        output.writeFloat(((Float)this.brightness.parsedValue()).floatValue());
        output.writeFloat(((Float)this.hueStep.parsedValue()).floatValue());
    }

    @Override
    public void restore(ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.hue.setFromDiscreteValue(input.readFloat());
        this.saturation.setFromDiscreteValue(input.readFloat());
        this.brightness.setFromDiscreteValue(input.readFloat());
        this.hueStep.setFromDiscreteValue(input.readFloat());
    }
}

