/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.utils.auto_placer;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.extend.EComponents;
import fzmm.zailer.me.client.gui.components.extend.EContainers;
import fzmm.zailer.me.client.gui.components.extend.component.ELabelComponent;
import fzmm.zailer.me.client.gui.components.extend.container.EFlowLayout;
import fzmm.zailer.me.client.gui.imagetext.HologramPlacerScreen;
import fzmm.zailer.me.client.gui.player_statue.PlayerStatuePlacerScreen;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.ItemUtils;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.hud.Hud;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;

public class AutoPlacerHud {
    public static boolean isHudActive = false;
    private static final class_2960 HUD_IDENTIFIER = class_2960.method_60655((String)"fzmm", (String)"auto_placer_hud");
    private static final List<Activation> activationList = new ArrayList<Activation>();

    private static void addHud(final BaseFzmmScreen screen, List<Requirement> requirements) {
        if (isHudActive) {
            return;
        }
        isHudActive = true;
        final List<Requirement> allRequirements = AutoPlacerHud.getRequirements(requirements);
        Hud.add((class_2960)HUD_IDENTIFIER, () -> {
            EFlowLayout mainLayout = EContainers.verticalFlow(Sizing.fill((int)70), Sizing.fill((int)70));
            ELabelComponent titleLabel = EComponents.label((class_2561)class_2561.method_43471((String)"fzmm.gui.autoPlacer.title"));
            titleLabel.positioning(Positioning.relative((int)50, (int)0));
            ELabelComponent requirementLabel = EComponents.label((class_2561)class_2561.method_43471((String)"fzmm.gui.autoPlacer.label.requirement"));
            final ELabelComponent currentRequirementLabel = EComponents.label((class_2561)class_2561.method_43473());
            EFlowLayout requirementLayout = EContainers.verticalFlow(Sizing.fill((int)100), Sizing.content());
            requirementLayout.child((Component)requirementLabel);
            requirementLayout.child((Component)currentRequirementLabel);
            requirementLayout.gap(4);
            requirementLayout.horizontalAlignment(HorizontalAlignment.CENTER);
            ELabelComponent sneakLabel = EComponents.label((class_2561)class_2561.method_43471((String)"fzmm.gui.autoPlacer.label.sneakInfo"));
            ELabelComponent cancelLabel = EComponents.label((class_2561)class_2561.method_43469((String)"fzmm.gui.autoPlacer.label.cancel", (Object[])new Object[]{FzmmClient.OPEN_MAIN_GUI_KEYBINDING.method_16007().getString()}));
            EFlowLayout bottomTextLayout = EContainers.verticalFlow(Sizing.fill((int)100), Sizing.content());
            bottomTextLayout.positioning(Positioning.relative((int)0, (int)100));
            bottomTextLayout.gap(4);
            bottomTextLayout.child((Component)cancelLabel);
            bottomTextLayout.child((Component)sneakLabel);
            BaseComponent eventComponent = new BaseComponent(){

                public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
                    if (!isHudActive) {
                        AutoPlacerHud.removeHud();
                        return;
                    }
                    for (Requirement requirement : allRequirements) {
                        if (requirement.predicate.get().booleanValue()) continue;
                        currentRequirementLabel.text(requirement.text);
                        return;
                    }
                    AutoPlacerHud.removeHud();
                    FzmmUtils.setScreen(screen);
                }
            };
            eventComponent.sizing(Sizing.fixed((int)1), Sizing.fixed((int)1));
            mainLayout.child((Component)eventComponent).child((Component)titleLabel).child((Component)requirementLayout).child((Component)bottomTextLayout).padding(Insets.of((int)16)).surface(Surface.VANILLA_TRANSLUCENT).alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER).positioning(Positioning.relative((int)50, (int)50));
            return mainLayout;
        });
    }

    private static List<Requirement> getRequirements(List<Requirement> requirements) {
        class_310 client = class_310.method_1551();
        assert (client.field_1724 != null);
        ArrayList<Requirement> allRequirements = new ArrayList<Requirement>(requirements);
        allRequirements.add(new Requirement(() -> client.field_1765 != null && client.field_1765.method_17783() == class_239.class_240.field_1332, (class_2561)class_2561.method_43471((String)"fzmm.gui.autoPlacer.label.baseRequirement.noBlock")));
        allRequirements.add(new Requirement(() -> client.field_1765 != null && client.field_1765.method_24801((class_1297)class_310.method_1551().field_1724) > 1.5, (class_2561)class_2561.method_43471((String)"fzmm.gui.autoPlacer.label.baseRequirement.notStandOn")));
        allRequirements.add(new Requirement(() -> client.field_1724.method_24828(), (class_2561)class_2561.method_43471((String)"fzmm.gui.autoPlacer.label.baseRequirement.isNotInGround")));
        return allRequirements;
    }

    public static boolean check(class_1799 stack) {
        for (Activation activation : activationList) {
            if (!activation.predicate.test(stack)) continue;
            AutoPlacerHud.addHud(activation.screenGetter.apply(stack), activation.requirements);
            return true;
        }
        return false;
    }

    public static void addActivation(Activation activateAutoPlacerRequirement) {
        activationList.add(activateAutoPlacerRequirement);
    }

    public static void init() {
        UseBlockCallback.EVENT.register(AutoPlacerHud::interactEvent);
        AutoPlacerHud.addActivation(PlayerStatuePlacerScreen.getActivation());
        AutoPlacerHud.addActivation(HologramPlacerScreen.getActivation());
    }

    private static class_1269 interactEvent(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (!world.method_8608()) {
            return class_1269.field_5811;
        }
        if (player.method_5715()) {
            return class_1269.field_5811;
        }
        if (ItemUtils.isNotAllowedToGive()) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        if (stack.method_57353().method_57837()) {
            return class_1269.field_5811;
        }
        return AutoPlacerHud.check(stack) ? class_1269.field_5814 : class_1269.field_5811;
    }

    public static void removeHud() {
        isHudActive = false;
        Hud.remove((class_2960)HUD_IDENTIFIER);
    }

    public record Requirement(Supplier<Boolean> predicate, class_2561 text) {
    }

    public record Activation(Predicate<class_1799> predicate, Function<class_1799, BaseFzmmScreen> screenGetter, List<Requirement> requirements) {
    }
}

