/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.head_generator.model;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.logic.head_generator.AbstractHeadEntry;
import fzmm.zailer.me.client.logic.head_generator.HeadResourcesLoader;
import fzmm.zailer.me.client.logic.head_generator.model.ModelData;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.ColorParameter;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.INestedParameters;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.IParameterEntry;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.OffsetParameter;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.ParameterList;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.ResettableModelParameter;
import fzmm.zailer.me.client.logic.head_generator.model.steps.IModelStep;
import fzmm.zailer.me.utils.ImageUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class HeadModelEntry
extends AbstractHeadEntry
implements INestedParameters {
    public static final String DESTINATION_ID = "destination_skin";
    public static final String BASE_SKIN_ID = "base_skin";
    private final List<IModelStep> steps = new ArrayList<IModelStep>();
    @Nullable
    private ParameterList<BufferedImage> textures = null;
    @Nullable
    private ParameterList<ColorParameter> colors = null;
    @Nullable
    private ParameterList<OffsetParameter> offsets = null;
    private boolean isPaintable = false;
    private boolean isEditingSkinBody = false;
    private boolean isFirstResult = false;
    private boolean isInternal = false;
    private boolean isInvertedLeftAndRight = false;

    public HeadModelEntry() {
        super("");
    }

    public HeadModelEntry(String key, List<IModelStep> steps, @Nullable ParameterList<BufferedImage> textures, @Nullable ParameterList<ColorParameter> colors, @Nullable ParameterList<OffsetParameter> offsets) {
        super(key);
        this.steps.addAll(steps);
        this.textures = textures;
        this.colors = colors;
        this.offsets = offsets;
    }

    public HeadModelEntry copy(String newPath) {
        HeadModelEntry result = new HeadModelEntry(newPath, this.steps, this.textures, this.colors, this.offsets);
        result.isPaintable(this.isPaintable);
        result.isEditingSkinBody(this.isEditingSkinBody);
        result.isFirstResult(this.isFirstResult);
        result.isInternal(this.isInternal);
        result.isInvertedLeftAndRight(this.isInvertedLeftAndRight);
        return result;
    }

    @Override
    public BufferedImage getHeadSkin(BufferedImage baseSkin, boolean hasUnusedPixels) {
        BufferedImage result = new BufferedImage(64, 64, 2);
        this.loadDefaultTexture();
        Graphics2D destinationGraphics = result.createGraphics();
        AffineTransform originalTransform = destinationGraphics.getTransform();
        if (hasUnusedPixels) {
            ImageUtils.removeUnusedPixels(destinationGraphics);
        }
        ModelData data = new ModelData(destinationGraphics, DESTINATION_ID, this.textures, this.colors, this.offsets, baseSkin, ColorParameter.getDefault(), this.isInvertedLeftAndRight(), (AffineTransform)originalTransform.clone());
        this.apply(data, baseSkin, result);
        destinationGraphics.setTransform(originalTransform);
        this.resetOffset();
        this.resetTexture();
        if (hasUnusedPixels) {
            ImageUtils.copyUnusedPixels(baseSkin, destinationGraphics);
        }
        destinationGraphics.dispose();
        return result;
    }

    public void apply(ModelData data, BufferedImage baseSkin, BufferedImage destinationSkin) {
        ParameterList<BufferedImage> textures = data.textures();
        textures.put(new ResettableModelParameter<BufferedImage>(BASE_SKIN_ID, baseSkin, null, false));
        textures.put(new ResettableModelParameter<BufferedImage>(DESTINATION_ID, destinationSkin, null, false));
        for (IModelStep step : this.steps) {
            step.apply(data);
        }
    }

    @Override
    public String getCategoryId() {
        return this.isPaintable ? "paintable" : "model";
    }

    @Override
    public boolean isEditingSkinBody() {
        return this.isEditingSkinBody;
    }

    public void isEditingSkinBody(boolean value) {
        this.isEditingSkinBody = value;
    }

    @Override
    public boolean isFirstResult() {
        return this.isFirstResult;
    }

    public void isFirstResult(boolean value) {
        this.isFirstResult = value;
    }

    public void isPaintable(boolean value) {
        this.isPaintable = value;
    }

    public boolean isPaintable() {
        return this.isPaintable;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public void isInternal(boolean value) {
        this.isInternal = value;
    }

    public void isInvertedLeftAndRight(boolean value) {
        this.isInvertedLeftAndRight = value;
    }

    public boolean isInvertedLeftAndRight() {
        return this.isInvertedLeftAndRight;
    }

    @Override
    public List<IModelStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<IModelStep> steps) {
        this.steps.clear();
        this.steps.addAll(steps);
    }

    public boolean validate() throws IllegalArgumentException {
        for (IModelStep step : this.getSteps()) {
            if (step.validate()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ParameterList<OffsetParameter> getOffsetParameters() {
        return this.offsets == null ? new ParameterList<OffsetParameter>() : this.offsets;
    }

    @Override
    public ParameterList<BufferedImage> getTextureParameters() {
        return this.textures == null ? new ParameterList<BufferedImage>() : this.textures;
    }

    @Override
    public ParameterList<ColorParameter> getColorParameters() {
        return this.colors == null ? new ParameterList<ColorParameter>() : this.colors;
    }

    private void loadDefaultTexture() {
        for (IParameterEntry<BufferedImage> textureParameter : this.getNestedTextureParameters().parameterList()) {
            String defaultValue;
            if (textureParameter.isRequested()) continue;
            BufferedImage texture = null;
            if (textureParameter instanceof ResettableModelParameter) {
                ResettableModelParameter resettableParam = (ResettableModelParameter)textureParameter;
                v0 = resettableParam.getDefaultValue();
            } else {
                v0 = defaultValue = null;
            }
            if (defaultValue != null) {
                Optional<BufferedImage> modelTexture = HeadResourcesLoader.getModelTexture(defaultValue);
                texture = modelTexture.orElseGet(() -> {
                    FzmmClient.LOGGER.warn("[HeadModelEntry] Could not find model texture '{}'", (Object)defaultValue);
                    return null;
                });
            }
            if (texture == null) {
                texture = new BufferedImage(64, 64, 2);
            }
            textureParameter.setValue(texture);
        }
    }

    public void resetOffset() {
        for (IParameterEntry<OffsetParameter> offset : this.getNestedOffsetParameters().parameterList()) {
            offset.value().ifPresent(OffsetParameter::reset);
        }
    }

    public void resetTexture() {
        for (IParameterEntry<BufferedImage> parameter : this.getNestedTextureParameters().parameterList()) {
            ResettableModelParameter resettableParam;
            if (!(parameter instanceof ResettableModelParameter) || (resettableParam = (ResettableModelParameter)parameter).isRequested() || resettableParam.getDefaultValue() != null) continue;
            resettableParam.value().ifPresent(Image::flush);
        }
    }
}

