/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.head_generator.model.steps.select;

import com.google.gson.JsonObject;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.logic.head_generator.HeadResourcesLoader;
import fzmm.zailer.me.client.logic.head_generator.model.ModelData;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.IParameterEntry;
import fzmm.zailer.me.client.logic.head_generator.model.steps.IModelStep;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Optional;

public class ModelSelectDestinationStep
implements IModelStep {
    private final String textureId;

    public ModelSelectDestinationStep(String textureId) {
        this.textureId = textureId;
    }

    @Override
    public void apply(ModelData data) {
        Optional<IParameterEntry<BufferedImage>> textureParamOptional = data.textures().getParameter(this.textureId);
        textureParamOptional.ifPresentOrElse(parameter -> {
            BufferedImage destination;
            Optional destionationOptional = parameter.value();
            if (destionationOptional.isEmpty()) {
                destination = new BufferedImage(64, 64, 2);
                parameter.setValue(destination);
            } else {
                if (data.destinationId().equals(this.textureId)) {
                    FzmmClient.LOGGER.warn("[ModelSelectDestinationStep] Destination texture already set to '{}'", (Object)this.textureId);
                    return;
                }
                destination = (BufferedImage)destionationOptional.get();
            }
            Graphics2D destinationGraphics = destination.createGraphics();
            if (!this.textureId.equals("destination_skin")) {
                data.destinationGraphics().dispose();
            }
            data.destinationGraphics(destinationGraphics);
            data.destinationId(this.textureId);
        }, () -> FzmmClient.LOGGER.warn("[ModelSelectTextureStep] Could not find texture parameter '{}'", (Object)this.textureId));
    }

    public static ModelSelectDestinationStep parse(JsonObject jsonObject) {
        String textureId = HeadResourcesLoader.get(jsonObject, "texture_id").getAsString();
        return new ModelSelectDestinationStep(textureId);
    }
}

