/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.player_statue;

import fzmm.zailer.me.builders.ArmorStandBuilder;
import fzmm.zailer.me.builders.ContainerBuilder;
import fzmm.zailer.me.builders.DisplayBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.extend.EStyles;
import fzmm.zailer.me.client.gui.components.snack_bar.BaseSnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarComponent;
import fzmm.zailer.me.client.gui.components.snack_bar.UpdatableSnackBarComponent;
import fzmm.zailer.me.client.gui.options.HorizontalDirectionOption;
import fzmm.zailer.me.client.logic.player_statue.StatuePart;
import fzmm.zailer.me.client.logic.player_statue.StatuePartEnum;
import fzmm.zailer.me.client.logic.player_statue.statue_head_skin.AbstractStatueSkinManager;
import fzmm.zailer.me.client.logic.player_statue.statue_head_skin.BodySkinManager;
import fzmm.zailer.me.client.logic.player_statue.statue_head_skin.ExtremitySkinManager;
import fzmm.zailer.me.client.logic.player_statue.statue_head_skin.HeadFace;
import fzmm.zailer.me.client.logic.player_statue.statue_head_skin.HeadModelSkin;
import fzmm.zailer.me.client.logic.player_statue.statue_head_skin.HeadSkinManager;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.ImageUtils;
import fzmm.zailer.me.utils.InventoryUtils;
import fzmm.zailer.me.utils.ItemUtils;
import fzmm.zailer.me.utils.SkinPart;
import fzmm.zailer.me.utils.SnackBarManager;
import io.wispforest.owo.ui.core.Sizing;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.joml.Vector3f;

public class PlayerStatue {
    private final List<StatuePart> statueList;
    private final String name;
    private BufferedImage playerSkin;
    private final Vector3f pos;
    private final HorizontalDirectionOption direction;
    private UpdatableSnackBarComponent snackBar;
    private int partsGenerated;
    private int totalToGenerate;
    private int currentErrors;
    private boolean isSecondTry;

    public PlayerStatue(BufferedImage playerSkin, String name, Vector3f pos, HorizontalDirectionOption direction) {
        this.playerSkin = playerSkin;
        this.name = name;
        this.statueList = new ArrayList<StatuePart>();
        this.pos = pos;
        this.direction = direction;
    }

    public PlayerStatue generateStatues() {
        this.statueList.clear();
        int scale = this.getSkinScale();
        if (FzmmClient.CONFIG.playerStatue.convertSkinWithAlexModelInSteveModel() && ImageUtils.isSlimSimpleCheck(this.playerSkin, scale)) {
            this.playerSkin = ImageUtils.convertInSteveModel(this.playerSkin, scale);
        }
        HeadModelSkin empty = new HeadModelSkin();
        HeadModelSkin bottom = new HeadModelSkin(HeadFace.HEAD_FACE.BOTTOM_FACE);
        HeadModelSkin top = new HeadModelSkin(HeadFace.HEAD_FACE.UP_FACE);
        HeadModelSkin left = new HeadModelSkin(HeadFace.HEAD_FACE.LEFT_FACE);
        HeadModelSkin right = new HeadModelSkin(HeadFace.HEAD_FACE.RIGHT_FACE);
        HeadModelSkin leftBottom = new HeadModelSkin(HeadFace.HEAD_FACE.BOTTOM_FACE, HeadFace.HEAD_FACE.LEFT_FACE);
        HeadModelSkin rightBottom = new HeadModelSkin(HeadFace.HEAD_FACE.BOTTOM_FACE, HeadFace.HEAD_FACE.RIGHT_FACE);
        this.statueList.add(new StatuePart(StatuePartEnum.LEFT_LEG, "Right bottom leg", 0, leftBottom, 0, 0, 0, new ExtremitySkinManager(SkinPart.LEFT_LEG, AbstractStatueSkinManager.Height.LOWER)));
        this.statueList.add(new StatuePart(StatuePartEnum.LEFT_LEG, "Right middle leg", 1, left, -2, 0, 1, new ExtremitySkinManager(SkinPart.LEFT_LEG, AbstractStatueSkinManager.Height.MIDDLE)));
        this.statueList.add(new StatuePart(StatuePartEnum.LEFT_LEG, "Right top leg", 2, left, 2, 0, 0, new ExtremitySkinManager(SkinPart.LEFT_LEG, AbstractStatueSkinManager.Height.UPPER)));
        this.statueList.add(new StatuePart(StatuePartEnum.LEFT_BODY, "Right bottom body", 3, empty, -1, 0, 0, new BodySkinManager(AbstractStatueSkinManager.Height.LOWER, true)));
        this.statueList.add(new StatuePart(StatuePartEnum.LEFT_BODY, "Right middle body", 4, empty, 1, 0, 0, new BodySkinManager(AbstractStatueSkinManager.Height.MIDDLE, true)));
        this.statueList.add(new StatuePart(StatuePartEnum.LEFT_BODY, "Right top body", 5, top, -1, 0, 0, new BodySkinManager(AbstractStatueSkinManager.Height.UPPER, true)));
        this.statueList.add(new StatuePart(StatuePartEnum.RIGHT_LEG, "Left bottom leg", 0, rightBottom, -1, 0, 0, new ExtremitySkinManager(SkinPart.RIGHT_LEG, AbstractStatueSkinManager.Height.LOWER)));
        this.statueList.add(new StatuePart(StatuePartEnum.RIGHT_LEG, "Left middle leg", 1, right, 1, 0, -1, new ExtremitySkinManager(SkinPart.RIGHT_LEG, AbstractStatueSkinManager.Height.MIDDLE)));
        this.statueList.add(new StatuePart(StatuePartEnum.RIGHT_LEG, "Left top leg", 2, right, -2, 0, 0, new ExtremitySkinManager(SkinPart.RIGHT_LEG, AbstractStatueSkinManager.Height.UPPER)));
        this.statueList.add(new StatuePart(StatuePartEnum.RIGHT_BODY, "Left bottom body", 3, empty, 0, 0, 0, new BodySkinManager(AbstractStatueSkinManager.Height.LOWER, false)));
        this.statueList.add(new StatuePart(StatuePartEnum.RIGHT_BODY, "Left middle body", 4, empty, -2, 0, 0, new BodySkinManager(AbstractStatueSkinManager.Height.MIDDLE, false)));
        this.statueList.add(new StatuePart(StatuePartEnum.RIGHT_BODY, "Left top body", 5, top, 0, 0, 0, new BodySkinManager(AbstractStatueSkinManager.Height.UPPER, false)));
        this.statueList.add(new StatuePart(StatuePartEnum.LEFT_ARM, "Right bottom arm", 3, bottom, 0, 0, 0, new ExtremitySkinManager(SkinPart.LEFT_ARM, AbstractStatueSkinManager.Height.LOWER)));
        this.statueList.add(new StatuePart(StatuePartEnum.LEFT_ARM, "Right middle arm", 4, empty, -2, 0, 1, new ExtremitySkinManager(SkinPart.LEFT_ARM, AbstractStatueSkinManager.Height.MIDDLE)));
        this.statueList.add(new StatuePart(StatuePartEnum.LEFT_ARM, "Right top arm", 5, top, 0, 0, 0, new ExtremitySkinManager(SkinPart.LEFT_ARM, AbstractStatueSkinManager.Height.UPPER)));
        this.statueList.add(new StatuePart(StatuePartEnum.RIGHT_ARM, "Left bottom arm", 3, bottom, -1, 0, 0, new ExtremitySkinManager(SkinPart.RIGHT_ARM, AbstractStatueSkinManager.Height.LOWER)));
        this.statueList.add(new StatuePart(StatuePartEnum.RIGHT_ARM, "Left middle arm", 4, empty, 1, 0, -1, new ExtremitySkinManager(SkinPart.RIGHT_ARM, AbstractStatueSkinManager.Height.MIDDLE)));
        this.statueList.add(new StatuePart(StatuePartEnum.RIGHT_ARM, "Left top arm", 5, top, -1, 0, 0, new ExtremitySkinManager(SkinPart.RIGHT_ARM, AbstractStatueSkinManager.Height.UPPER)));
        this.statueList.add(new StatuePart(StatuePartEnum.LEFT_HEAD_FRONT, "Right bottom front head", 6, bottom, 1, 0, 0, new HeadSkinManager(false, true, false)));
        this.statueList.add(new StatuePart(StatuePartEnum.LEFT_HEAD_FRONT, "Right top front head", 7, top, 2, 0, 2, new HeadSkinManager(false, false, false)));
        this.statueList.add(new StatuePart(StatuePartEnum.LEFT_HEAD_BACK, "Right bottom back head", 6, bottom, 0, 0, 1, new HeadSkinManager(false, true, true)));
        this.statueList.add(new StatuePart(StatuePartEnum.LEFT_HEAD_BACK, "Right top back head", 7, top, -3, 0, -3, new HeadSkinManager(false, false, true)));
        this.statueList.add(new StatuePart(StatuePartEnum.RIGHT_HEAD_FRONT, "Left bottom front head", 6, bottom, -1, 0, 0, new HeadSkinManager(true, true, false)));
        this.statueList.add(new StatuePart(StatuePartEnum.RIGHT_HEAD_FRONT, "Left top front head", 7, top, 1, 0, -1, new HeadSkinManager(true, false, false)));
        this.statueList.add(new StatuePart(StatuePartEnum.RIGHT_HEAD_BACK, "Left bottom back head", 6, bottom, 1, 0, -2, new HeadSkinManager(true, true, true)));
        this.statueList.add(new StatuePart(StatuePartEnum.RIGHT_HEAD_BACK, "Left top back head", 7, top, -2, 0, 1, new HeadSkinManager(true, false, true)));
        this.totalToGenerate = this.statueList.size();
        this.partsGenerated = 0;
        this.currentErrors = 0;
        this.isSecondTry = false;
        class_310.method_1551().execute(() -> {
            this.snackBar = (UpdatableSnackBarComponent)UpdatableSnackBarComponent.builder("player_statue").backgroundColor(EStyles.ALERT_LOADING_COLOR).keepOnLimit().title((class_2561)class_2561.method_43471((String)"fzmm.snack_bar.playerStatue.loading.title")).details((class_2561)class_2561.method_43469((String)"fzmm.snack_bar.playerStatue.loading.details", (Object[])new Object[]{this.partsGenerated, 0, 0, 0, this.statueList.get(0).getName()})).sizing(Sizing.fixed((int)220), Sizing.content()).startTimer().build();
            SnackBarManager.getInstance().add(this.snackBar);
        });
        this.generate();
        this.isSecondTry = true;
        this.generate();
        class_310.method_1551().execute(() -> {
            this.snackBar.close();
            boolean success = this.currentErrors == 0;
            ISnackBarComponent finalStatus = BaseSnackBarComponent.builder("player_statue").backgroundColor(success ? EStyles.ALERT_SUCCESS_COLOR : EStyles.ALERT_ERROR_COLOR).keepOnLimit().title((class_2561)(success ? class_2561.method_43471((String)"fzmm.snack_bar.playerStatue.successful.title") : class_2561.method_43469((String)"fzmm.snack_bar.playerStatue.error.title", (Object[])new Object[]{this.currentErrors}))).sizing(Sizing.fixed((int)220), Sizing.content()).mediumTimer().startTimer().build();
            SnackBarManager.getInstance().add(finalStatus);
        });
        return this;
    }

    public void generate() {
        int delayMillis = 0;
        for (StatuePart statuePart : this.statueList) {
            if (statuePart.isSkinGenerated()) continue;
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(delayMillis));
            try {
                delayMillis = statuePart.setStatueSkin(this.playerSkin, this.getSkinScale()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                FzmmClient.LOGGER.error("[PlayerStatue] The statue '{}' had an internal error generating its skin", (Object)statuePart.getName());
                delayMillis = 6000;
            }
            this.updateStatus(statuePart, delayMillis);
        }
    }

    public static class_1799 getStatueName(Vector3f pos, String name) {
        float x = pos.x() + 0.5f;
        float y = pos.y() - 0.1f;
        float z = pos.z() + 0.5f;
        class_5455 registryManager = FzmmUtils.getRegistryManager();
        class_2561 nameText = class_2561.method_30163((String)name);
        if (name != null && !name.isEmpty()) {
            try {
                nameText = class_2561.class_2562.method_10877((String)name, (class_7225.class_7874)registryManager);
                if (nameText == null) {
                    throw new IllegalArgumentException(String.format("[PlayerStatue] 'name' is not a valid JSON string: %s", name));
                }
            }
            catch (Exception ignored) {
                if (name.length() > 100) {
                    name = name.substring(0, 99);
                }
                nameText = class_2561.method_30163((String)name);
            }
        }
        class_1799 nameTagStack = ArmorStandBuilder.builder().setPos(x, y, z).setAsHologram(nameText).setTags("PlayerStatue").getItem("Name tag");
        nameTagStack.method_57368(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)new class_2487()), component -> {
            class_2487 result = component.method_57461();
            class_2487 fzmmTag = new class_2487();
            class_2487 playerStatueTag = new class_2487();
            playerStatueTag.method_10567("nameTag", (byte)1);
            fzmmTag.method_10566("PlayerStatue", (class_2520)playerStatueTag);
            result.method_10566("FZMM_MOD", (class_2520)fzmmTag);
            return class_9279.method_57456((class_2487)result);
        });
        return nameTagStack;
    }

    public static boolean isNameTag(class_1799 stack) {
        class_2487 customData = ((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)new class_2487()))).method_57461();
        class_2487 fzmmTag = customData.method_10562("FZMM_MOD");
        if (!fzmmTag.method_10573("PlayerStatue", 10)) {
            return false;
        }
        class_2487 playerStatueTag = fzmmTag.method_10562("PlayerStatue");
        return playerStatueTag.method_10573("nameTag", 1);
    }

    public List<class_1799> getStatueItems() {
        ArrayList<class_1799> stackList = new ArrayList<class_1799>();
        for (StatuePart statue : this.statueList) {
            stackList.add(statue.get(this.pos, this.direction));
        }
        if (!this.name.isEmpty()) {
            stackList.add(PlayerStatue.getStatueName(this.pos, this.name));
        }
        return stackList;
    }

    public class_1799 getStatueInContainer() {
        return PlayerStatue.getStatueInContainer(this.getStatueItems(), this.pos);
    }

    public static class_1799 getStatueInContainer(List<class_1799> statueList, Vector3f pos) {
        DecimalFormat decimalFormat = new DecimalFormat(".00");
        String x = decimalFormat.format(pos.x());
        String y = decimalFormat.format(pos.y());
        String z = decimalFormat.format(pos.z());
        int color = FzmmClient.CONFIG.colors.playerStatue().rgb();
        class_2583 colorStyle = class_2583.field_24360.method_36139(color);
        List<class_1799> containerList = ContainerBuilder.builder().containerItem(ItemUtils.from(FzmmClient.CONFIG.playerStatue.defaultContainer())).addAll(statueList).setNameStyleToItems(colorStyle).addLoreToItems(class_1802.field_8694, class_2561.method_43471((String)"fzmm.item.playerStatue.lore.1").getString(), color).addLoreToItems(class_1802.field_8694, class_2561.method_43471((String)"fzmm.item.playerStatue.lore.2").getString(), color).getAsList();
        if (containerList.isEmpty()) {
            return class_1799.field_8037;
        }
        class_1799 container = containerList.get(0);
        container = DisplayBuilder.of(container).setName(class_2561.method_43470((String)class_2561.method_43471((String)"fzmm.item.playerStatue.container.name").getString()).method_10862(colorStyle.method_10982(Boolean.valueOf(true)))).addLore((class_2561)class_2561.method_43469((String)"fzmm.item.playerStatue.container.lore.1", (Object[])new Object[]{x, y, z}), color).get();
        return container;
    }

    public void updateStatus(StatuePart part, int delayMillis) {
        String translationKey;
        String string = translationKey = this.isSecondTry ? "secondTry" : "loading";
        if (part.isSkinGenerated()) {
            ++this.partsGenerated;
            if (this.isSecondTry) {
                --this.currentErrors;
            }
        } else if (!this.isSecondTry) {
            ++this.currentErrors;
        }
        class_310.method_1551().execute(() -> {
            float delay = (float)delayMillis / 1000.0f;
            this.snackBar.updateTitle((class_2561)class_2561.method_43471((String)("fzmm.snack_bar.playerStatue." + translationKey + ".title")));
            this.snackBar.updateDetails((class_2561)class_2561.method_43469((String)("fzmm.snack_bar.playerStatue." + translationKey + ".details"), (Object[])new Object[]{this.partsGenerated, this.currentErrors, this.totalToGenerate, new DecimalFormat("#,#0.0").format(delay), part.getName()}));
            this.snackBar.updateTimerBar((float)this.partsGenerated / (float)this.totalToGenerate);
            if (!this.snackBar.hasParent()) {
                SnackBarManager.getInstance().add(this.snackBar);
            }
        });
    }

    public static class_1799 updateStatue(class_1799 container, Vector3f pos, HorizontalDirectionOption direction, String name) {
        List<class_1799> containerItems = InventoryUtils.getItemsFromContainer(container);
        ArrayList<class_1799> statueList = new ArrayList<class_1799>();
        for (class_1799 stack : containerItems) {
            if (StatuePart.isStatue(stack)) {
                statueList.add(StatuePart.ofItem(stack).get(pos, direction));
                continue;
            }
            if (!PlayerStatue.isNameTag(stack)) continue;
            statueList.add(PlayerStatue.getStatueName(pos, name));
        }
        return PlayerStatue.getStatueInContainer(statueList, pos);
    }

    public static boolean isPlayerStatue(class_1799 container) {
        List<class_1799> containerItems = InventoryUtils.getItemsFromContainer(container);
        if (containerItems.isEmpty()) {
            return false;
        }
        for (class_1799 stack : containerItems) {
            if (StatuePart.isStatue(stack) || PlayerStatue.isNameTag(stack)) continue;
            return false;
        }
        return true;
    }

    private int getSkinScale() {
        return this.playerSkin.getHeight() == 128 && this.playerSkin.getWidth() == 128 ? 2 : 1;
    }
}

