/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.config;

import io.wispforest.owo.config.annotation.Config;
import io.wispforest.owo.config.annotation.ExcludeFromScreen;
import io.wispforest.owo.config.annotation.Expanded;
import io.wispforest.owo.config.annotation.Hook;
import io.wispforest.owo.config.annotation.Modmenu;
import io.wispforest.owo.config.annotation.Nest;
import io.wispforest.owo.config.annotation.PredicateConstraint;
import io.wispforest.owo.config.annotation.RangeConstraint;
import io.wispforest.owo.config.annotation.RestartRequired;
import io.wispforest.owo.config.annotation.SectionHeader;
import io.wispforest.owo.ui.core.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

@Modmenu(modId="fzmm")
@Config(name="fzmm", wrapperName="FzmmConfig")
public class FzmmConfigModel {
    @Nest
    @Expanded
    public GeneralNest general = new GeneralNest();
    @Nest
    public ColorsNest colors = new ColorsNest();
    @Nest
    public GuiStyleNest guiStyle = new GuiStyleNest();
    @Nest
    @SectionHeader(value="externalAPIs")
    public MineskinNest mineskin = new MineskinNest();
    @Nest
    public HeadGalleryNest headGallery = new HeadGalleryNest();
    @SectionHeader(value="gui")
    @Nest
    public ImagetextNest imagetext = new ImagetextNest();
    @Nest
    public TextFormatNest textFormat = new TextFormatNest();
    @Nest
    public PlayerStatueNest playerStatue = new PlayerStatueNest();
    @Nest
    public EncryptbookNest encryptbook = new EncryptbookNest();
    @Nest
    public HeadGeneratorNest headGenerator = new HeadGeneratorNest();
    @Nest
    public HistoryNest history = new HistoryNest();
    @Nest
    public ItemEditorBannerNest itemEditorBanner = new ItemEditorBannerNest();

    public static boolean predicateItem(String value) {
        return class_7923.field_41178.method_17966(class_2960.method_60654((String)value)).isPresent();
    }

    public static class GeneralNest {
        public boolean disableItalic = true;
        public boolean forceInvisibleItemFrame = false;
        public boolean giveClientSide = false;
        public boolean showSymbolButton = true;
        public boolean showItemSize = true;
        public boolean checkValidCodec = true;
        public boolean giveItemSizeLimit = true;
        public boolean minimizeHeadTexturesTag = true;
        public boolean removeViaVersionTags = true;
    }

    public static class ColorsNest {
        public Color imagetextHologram = Color.ofRgb((int)15843890);
        public Color imagetextMessages = Color.ofRgb((int)7455391);
        public Color playerStatue = Color.ofRgb((int)13317245);
        public Color usefulBlockStates = Color.ofRgb((int)6747575);
        public Color headGalleryName = Color.ofRgb((int)5287792);
        public Color headGalleryTags = Color.ofRgb((int)7655471);
        @ExcludeFromScreen
        public List<Color> favoriteColors = new ArrayList<Color>();
    }

    public static class GuiStyleNest {
        public boolean oldBackground = false;
        public boolean persistentScrollbar = true;
    }

    public static class MineskinNest {
        public String apiKey = "";
        public boolean publicSkins = false;
    }

    public static class HeadGalleryNest {
        @RestartRequired
        public boolean cacheCategories = true;
        public boolean setStyleToHeads = true;
        @RangeConstraint(min=1.0, max=2500.0)
        public int maxHeadsPerPage = 300;
        @RangeConstraint(min=1.0, max=3.0, decimalPlaces=1)
        public double itemScale = 1.5;
    }

    public static class ImagetextNest {
        public String defaultBookMessage = "Hover over this message to see an image";
        @PredicateConstraint(value="predicateItem")
        public String defaultItem = class_1802.field_8407.toString();
        public boolean defaultPreserveImageAspectRatio = true;
        @ExcludeFromScreen
        public int maxResolution = 127;
        @RangeConstraint(min=0.0, max=10.0, decimalPlaces=1)
        public double defaultSimilarityThreshold = 2.5;

        public static boolean predicateItem(String value) {
            return FzmmConfigModel.predicateItem(value);
        }
    }

    public static class TextFormatNest {
        @PredicateConstraint(value="predicateItem")
        public String defaultItem = class_1802.field_8448.toString();
        @RangeConstraint(min=0.0010000000474974513, max=0.10000000149011612, decimalPlaces=3)
        public float minRainbowHueStep = 0.005f;
        @RangeConstraint(min=0.009999999776482582, max=0.9900000095367432)
        public float maxRainbowHueStep = 0.15f;

        public static boolean predicateItem(String value) {
            return FzmmConfigModel.predicateItem(value);
        }
    }

    public static class PlayerStatueNest {
        public boolean convertSkinWithAlexModelInSteveModel = true;
        @PredicateConstraint(value="predicateItem")
        public String defaultContainer = class_1802.field_8722.toString();

        public static boolean predicateItem(String value) {
            return FzmmConfigModel.predicateItem(value);
        }
    }

    public static class EncryptbookNest {
        public String defaultBookMessage = "Hello world";
        public String defaultBookTitle = "Encode book (%s)";
        public String padding = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_,.";
        public String separatorMessage = "-----";
        @ExcludeFromScreen
        public List<TranslationEncryptProfileModel> profiles = new ArrayList<TranslationEncryptProfileModel>(List.of(new TranslationEncryptProfileModel()));
    }

    public static class HeadGeneratorNest {
        @ExcludeFromScreen
        public Set<String> favoriteSkins = new HashSet<String>();
        public boolean forcePreEditNoneInModels = true;
    }

    public static class HistoryNest {
        @Hook
        public int maxItemHistory = 100;
        @Hook
        public int maxHeadHistory = 100;
        public boolean automaticallyRecoverScreens = true;
    }

    public static class ItemEditorBannerNest {
        @RangeConstraint(min=0.0, max=300.0, decimalPlaces=0)
        public int maxUndo = 75;
    }

    public static final class TranslationEncryptProfileModel {
        public int seed = 0;
        @RangeConstraint(min=1.0, max=512.0)
        public int length = 255;
        public String key = "secret_mc_%s";
        public int asymmetricValue = 0;
        @RangeConstraint(min=1.0, max=2.0)
        public int algorithmVersion = 2;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TranslationEncryptProfileModel that = (TranslationEncryptProfileModel)o;
            return this.seed == that.seed && this.length == that.length && this.asymmetricValue == that.asymmetricValue && this.algorithmVersion == that.algorithmVersion && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.seed, this.length, this.key, this.asymmetricValue, this.algorithmVersion);
        }
    }
}

