/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.utils;

import java.io.DataOutput;
import org.jetbrains.annotations.NotNull;

public class ByteCountDataOutput
implements DataOutput {
    private static ByteCountDataOutput instance = null;
    private long count = 0L;

    private ByteCountDataOutput() {
    }

    public static ByteCountDataOutput getInstance() {
        if (instance == null) {
            instance = new ByteCountDataOutput();
        }
        return instance;
    }

    public long getCount() {
        return this.count;
    }

    public void reset() {
        this.count = 0L;
    }

    @Override
    public void write(int b) {
        ++this.count;
    }

    @Override
    public void write(byte[] b) {
        this.count += (long)b.length;
    }

    @Override
    public void write(byte @NotNull [] b, int off, int len) {
        this.count += (long)len;
    }

    @Override
    public void writeBoolean(boolean v) {
        ++this.count;
    }

    @Override
    public void writeByte(int v) {
        ++this.count;
    }

    @Override
    public void writeShort(int v) {
        this.count += 2L;
    }

    @Override
    public void writeChar(int v) {
        this.count += 2L;
    }

    @Override
    public void writeInt(int v) {
        this.count += 4L;
    }

    @Override
    public void writeLong(long v) {
        this.count += 8L;
    }

    @Override
    public void writeFloat(float v) {
        this.count += 4L;
    }

    @Override
    public void writeDouble(double v) {
        this.count += 8L;
    }

    @Override
    public void writeBytes(String s) {
        this.count += (long)s.length();
    }

    @Override
    public void writeChars(String s) {
        this.count += (long)s.length() * 2L;
    }

    @Override
    public void writeUTF(@NotNull String s) {
        this.count += (long)(2 + this.getUTFLength(s));
    }

    public int getUTFLength(String s) {
        int count = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                count += 4;
                ++i;
                continue;
            }
            count += 3;
        }
        return count;
    }
}

