/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import fzmm.zailer.me.builders.HeadBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.config.FzmmConfig;
import fzmm.zailer.me.utils.TextUtils;
import fzmm.zailer.me.utils.skin.CacheSkinGetter;
import io.wispforest.owo.Owo;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_8685;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public class HeadUtils {
    public static final String MINESKIN_API = "https://api.mineskin.org/";
    private static final String BOUNDARY = UUID.randomUUID().toString();
    private String skinValue = "";
    private String signature = "";
    private String url = "";
    private boolean skinGenerated = false;
    private int httpResponseCode = 0;
    private int delayForNextInMillis = 6000;

    public HeadBuilder getBuilder() {
        return HeadBuilder.builder().skinValue(this.skinValue).signature(this.signature);
    }

    public String getSkinValue() {
        return this.skinValue;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isSkinGenerated() {
        return this.skinGenerated;
    }

    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public int getDelayForNext(TimeUnit unit) {
        return (int)unit.convert(this.delayForNextInMillis, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<HeadUtils> uploadHead(BufferedImage headSkin, String skinName) {
        return CompletableFuture.supplyAsync(() -> {
            HttpURLConnection conn = null;
            try {
                FzmmConfig.Mineskin config = FzmmClient.CONFIG.mineskin;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)headSkin, "png", baos);
                byte[] skin = baos.toByteArray();
                URL url = URI.create("https://api.mineskin.org/generate/upload").toURL();
                conn = (HttpURLConnection)url.openConnection();
                conn.setDoOutput(true);
                conn.setConnectTimeout(8000);
                conn.setReadTimeout(8000);
                conn.setRequestProperty("User-Agent", "FZMM/1.0");
                conn.setRequestMethod("POST");
                if (!config.apiKey().isEmpty()) {
                    conn.setRequestProperty("Authorization", "Bearer " + config.apiKey());
                }
                conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
                try (DataOutputStream dataOutputStream = new DataOutputStream(conn.getOutputStream());){
                    dataOutputStream.writeBytes("--" + BOUNDARY + "\r\n");
                    dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"visibility\"\r\n");
                    dataOutputStream.writeBytes("Content-Type: text/plain\r\n\r\n");
                    dataOutputStream.writeBytes(config.publicSkins() ? "0" : "1");
                    dataOutputStream.writeBytes("\r\n--" + BOUNDARY + "\r\n");
                    dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"file\"; filename=\"head\"\r\n");
                    dataOutputStream.writeBytes("Content-Type: application/x-www-form-urlencoded\r\n\r\n");
                    dataOutputStream.write(skin);
                    dataOutputStream.writeBytes("\r\n--" + BOUNDARY + "--\r\n");
                }
                this.readResponse(skinName, conn);
            }
            catch (IOException e) {
                FzmmClient.LOGGER.error("[HeadUtils] Head '{}' could not be generated", (Object)skinName, (Object)e);
                this.skinValue = "";
                this.skinGenerated = false;
                if (this.httpResponseCode == 0) {
                    this.httpResponseCode = 400;
                }
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            if (!this.skinGenerated) {
                this.delayForNextInMillis = 6000;
            }
            return this;
        }, class_156.method_55473());
    }

    private void readResponse(String skinName, HttpURLConnection conn) throws IOException {
        this.httpResponseCode = conn.getResponseCode();
        boolean isSuccess = this.httpResponseCode / 100 == 2;
        try (InputStreamReader streamReader = new InputStreamReader(isSuccess ? conn.getInputStream() : conn.getErrorStream());){
            int character;
            StringBuilder stringBuilder = new StringBuilder();
            while ((character = streamReader.read()) != -1) {
                stringBuilder.append((char)character);
            }
            String reply = stringBuilder.toString();
            if (Owo.DEBUG) {
                FzmmClient.LOGGER.info("[DEBUG] [HeadUtils] HTTP Code: {}, Delay: {}, Received response: {}", new Object[]{this.httpResponseCode, this.delayForNextInMillis, reply});
            }
            JsonObject json = (JsonObject)JsonParser.parseString((String)reply);
            if (isSuccess) {
                FzmmClient.LOGGER.info("[HeadUtils] '{}' head generated using mineskin", (Object)skinName);
                this.useSuccessResponse(json);
            } else {
                this.logErrorResponse(json, skinName);
            }
        }
        catch (NullPointerException e) {
            FzmmClient.LOGGER.error("[HeadUtils] Failed to get head values from mineskin api", (Throwable)e);
        }
    }

    private void useSuccessResponse(JsonObject json) {
        JsonObject texture = json.getAsJsonObject("data").getAsJsonObject("texture");
        this.skinValue = texture.get("value").getAsString();
        this.signature = texture.get("signature").getAsString();
        this.url = texture.get("url").getAsString();
        this.skinGenerated = true;
        this.delayForNextInMillis = json.getAsJsonObject("delayInfo").get("millis").getAsInt();
    }

    private void logErrorResponse(JsonObject json, String skinName) {
        String code = json.get("errorCode").getAsString();
        String error = json.get("error").getAsString();
        FzmmClient.LOGGER.error("[HeadUtils] HTTP error {}, generating skin '{}', Code: '{}', Error: '{}'", new Object[]{this.httpResponseCode, skinName, code, error});
    }

    public static Optional<BufferedImage> getSkin(class_1799 stack) throws IOException {
        class_9296 profileComponent = (class_9296)stack.method_57824(class_9334.field_49617);
        if (profileComponent == null) {
            return Optional.empty();
        }
        return new CacheSkinGetter().getSkin(profileComponent.comp_2413());
    }

    public static Optional<class_8685> getSkinTextures(class_1799 stack) {
        class_9296 profileComponent = (class_9296)stack.method_57824(class_9334.field_49617);
        if (profileComponent == null) {
            return Optional.empty();
        }
        return Optional.of(class_310.method_1551().method_1582().method_52862(profileComponent.comp_2413()));
    }

    public static Optional<class_1799> uploadAndGetHead(String playerName) {
        Optional<BufferedImage> skinOptional = new CacheSkinGetter().getSkin(playerName);
        if (skinOptional.isEmpty()) {
            return Optional.empty();
        }
        class_1799 stack = null;
        try {
            stack = new HeadUtils().uploadHead(skinOptional.get(), playerName).get().getBuilder().headName(playerName).get();
        }
        catch (InterruptedException | ExecutionException e) {
            FzmmClient.LOGGER.error("[HeadUtils] Error uploading head in mineskin", (Throwable)e);
        }
        return Optional.ofNullable(stack);
    }

    public static class_9296 minimizeTextures(GameProfile profile) {
        class_9296 profileComponent = new class_9296(profile);
        Optional<String> unwrappedUrl = HeadUtils.unwrapUrl(profileComponent);
        if (unwrappedUrl.isEmpty()) {
            return profileComponent;
        }
        PropertyMap propertiesMap = new PropertyMap();
        propertiesMap.put((Object)"textures", (Object)new Property("textures", HeadUtils.wrapUrl(unwrappedUrl.get())));
        return new class_9296(Optional.of(profile.getName()), Optional.of(profile.getId()), propertiesMap);
    }

    public static Optional<String> unwrapUrl(class_9296 profileComponent) {
        List texturesProperties = profileComponent.comp_2412().get((Object)"textures").stream().toList();
        if (texturesProperties.isEmpty()) {
            return Optional.empty();
        }
        Optional<String> textureValueOptional = TextUtils.decodeBase64(((Property)texturesProperties.get(0)).value());
        if (textureValueOptional.isEmpty()) {
            return Optional.empty();
        }
        try {
            JsonObject json = JsonParser.parseString((String)textureValueOptional.get()).getAsJsonObject();
            if (!json.has("textures") || !json.get("textures").isJsonObject()) {
                return Optional.empty();
            }
            JsonObject textures = json.getAsJsonObject("textures");
            if (!textures.has("SKIN") || !textures.get("SKIN").isJsonObject()) {
                return Optional.empty();
            }
            json = textures.get("SKIN").getAsJsonObject();
            if (!json.has("url") || !json.get("url").isJsonPrimitive()) {
                return Optional.empty();
            }
            JsonPrimitive jsonUrl = json.getAsJsonPrimitive("url");
            if (!jsonUrl.isString()) {
                return Optional.empty();
            }
            return Optional.of(jsonUrl.getAsString());
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    public static String wrapUrl(String url) {
        JsonObject skin = new JsonObject();
        skin.addProperty("url", url);
        JsonObject textures = new JsonObject();
        textures.add("SKIN", (JsonElement)skin);
        JsonObject json = new JsonObject();
        json.add("textures", (JsonElement)textures);
        return TextUtils.encodeBase64(json.toString());
    }
}

