/*
 * Decompiled with CFR 0.152.
 */
package b3hav1.seatbelt;

import b3hav1.seatbelt.custom.Display;
import b3hav1.seatbelt.custom.Sound;
import b3hav1.seatbelt.server.PacketHandler;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="seatbelt")
public class Seatbelt {
    public static final String MODID = "seatbelt";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<UUID, Boolean> PLAYER_FASTENED = new ConcurrentHashMap<UUID, Boolean>();
    public static boolean playerNotified = false;

    public Seatbelt() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandler.registerMessages();
    }

    private static boolean isFastened(Player player) {
        return PLAYER_FASTENED.getOrDefault(player.m_20148_(), false);
    }

    public static void toggle(Player player) {
        boolean state = !Seatbelt.isFastened(player);
        PLAYER_FASTENED.put(player.m_20148_(), state);
        Display.hint(player, state ? "fasten" : "unfasten");
        Sound.onServer(player, state ? SoundEvents.f_11678_ : SoundEvents.f_11675_);
    }

    public static void reset(Player player) {
        PLAYER_FASTENED.remove(player.m_20148_());
        playerNotified = false;
    }

    public static void dismount(Player player, EntityMountEvent event) {
        if (!Seatbelt.isFastened(player)) {
            return;
        }
        event.setCanceled(true);
        Display.hint(player, "dismount");
    }

    public static void dismountNotify(Player player, boolean dismount) {
        if (dismount && !playerNotified && Seatbelt.isFastened(player)) {
            Sound.onClient(player, (Holder<SoundEvent>)SoundEvents.f_12215_);
        }
        playerNotified = dismount;
    }
}

