/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.item.gear;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.trique.gemforged.effect.GemforgedEffects;
import org.joml.Vector3f;

public class BattleCharmItem
extends Item {
    private static final float PARTICLE_DENSITY_SCALE = 1.0f;
    private static final float DUST_SIZE_SCALE = 2.0f;
    private static final float RADIUS = 8.0f;
    private static final int COOLDOWN_TICKS = 1800;
    private static final int USE_DURATION_TICKS = 20;
    private static final int DURATION_GARNET_RAGE = 600;
    private static final int AMP_GARNET = 0;
    private static final int FRAME_STEP = 1;
    private static final int FRAMES = 8;
    private static final float WAVE_START = 6.4f;
    private static final float WAVE_END = 24.0f;
    private static final int VERTICAL_COLUMNS = 12;
    private static final float COLUMN_HEIGHT = 3.5f;
    private static final DustParticleOptions RED_MAIN = new DustParticleOptions(new Vector3f(0.98f, 0.07f, 0.1f), 4.0f);
    private static final DustParticleOptions RED_GLOW = new DustParticleOptions(new Vector3f(1.0f, 0.22f, 0.26f), 4.8f);
    private static final DustParticleOptions RED_DEEP = new DustParticleOptions(new Vector3f(0.55f, 0.0f, 0.08f), 3.2f);

    public BattleCharmItem(Item.Properties props) {
        super(props.durability(250));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        if (!level.isClientSide) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 0.75f, 1.25f);
        }
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    }

    public void onUseTick(Level level, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (level.isClientSide) {
            return;
        }
        int elapsed = this.getUseDuration(stack, user) - remainingUseTicks;
        if (elapsed == 1) {
            level.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 0.7f, 1.05f);
        }
        if (elapsed % 5 == 0) {
            float pitch = 0.9f + (float)elapsed / 20.0f * 0.5f;
            level.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.AMETHYST_BLOCK_RESONATE, SoundSource.PLAYERS, 0.35f, pitch);
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 20;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        if (!level.isClientSide && user instanceof Player) {
            Player player = (Player)user;
            this.triggerBurst((ServerLevel)level, player);
            stack.hurtAndBreak(1, user, EquipmentSlot.MAINHAND);
            player.getCooldowns().addCooldown((Item)this, 1800);
        }
        return super.finishUsingItem(stack, level, user);
    }

    private void triggerBurst(ServerLevel level, Player player) {
        Vec3 c = player.position();
        level.playSound(null, c.x, c.y, c.z, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 2.0f, 0.1f);
        level.playSound(null, c.x, c.y, c.z, SoundEvents.AMETHYST_BLOCK_RESONATE, SoundSource.PLAYERS, 2.0f, 0.1f);
        this.spawnRing(level, c.add(0.0, 0.2, 0.0), 8.0f, BattleCharmItem.scaledCount(105), RED_MAIN);
        this.spawnRing(level, c.add(0.0, 0.5, 0.0), 6.0f, BattleCharmItem.scaledCount(85), RED_GLOW);
        this.spawnLingeringCloud(level, c, 3.0f, 8.8f);
        this.scheduleWave(level, c);
        AABB box = AABB.ofSize((Vec3)c, (double)10.0, (double)8.0, (double)10.0);
        List targets = level.getEntitiesOfClass(LivingEntity.class, box, e -> e.isAlive() && (e == player || e.isAlliedTo((Entity)player)));
        Holder.Reference garnetRage = level.registryAccess().lookupOrThrow(Registries.MOB_EFFECT).getOrThrow(GemforgedEffects.GARNET_RAGE_KEY);
        for (LivingEntity e2 : targets) {
            e2.addEffect(new MobEffectInstance((Holder)garnetRage, 600, 0, true, true));
        }
    }

    private void scheduleWave(ServerLevel level, Vec3 center) {
        int start = level.getServer().getTickCount();
        for (int f = 0; f <= 8; ++f) {
            int when = start + f * 1;
            float t = (float)f / 8.0f;
            float tt = BattleCharmItem.easeOutCubic(t);
            float radius = BattleCharmItem.lerp(6.4f, 24.0f, tt);
            double yLift = 0.05 * (double)f;
            level.getServer().tell((Runnable)new TickTask(when, () -> {
                this.spawnRing(level, center.add(0.0, yLift, 0.0), radius, BattleCharmItem.scaledCount(95), RED_MAIN);
                this.spawnRing(level, center.add(0.0, yLift + 0.12, 0.0), radius * 0.92f, BattleCharmItem.scaledCount(80), RED_GLOW);
                this.spawnVerticalColumnsFrame(level, center, radius, 3.5f, 12);
            }));
        }
    }

    private void spawnVerticalColumnsFrame(ServerLevel level, Vec3 center, float radius, float height, int columns) {
        double cx = center.x;
        double cy = center.y;
        double cz = center.z;
        double stepAngle = Math.PI * 2 / (double)columns;
        for (int i = 0; i < columns; ++i) {
            double a = (double)i * stepAngle;
            double x = cx + (double)radius * Math.cos(a);
            double z = cz + (double)radius * Math.sin(a);
            int samples = 8;
            for (int j = 0; j < samples; ++j) {
                double u = (double)j / (double)(samples - 1);
                double y = cy + 0.2 + u * (double)height;
                if ((j & 1) == 0) {
                    level.sendParticles((ParticleOptions)RED_DEEP, x, y, z, 1, 0.02, 0.06, 0.02, 0.0);
                } else {
                    level.sendParticles((ParticleOptions)RED_GLOW, x, y, z, 1, 0.02, 0.06, 0.02, 0.0);
                }
                if (j != samples - 1) continue;
                level.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, x, y + 0.02, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void spawnRing(ServerLevel level, Vec3 center, float radius, int points, DustParticleOptions dust) {
        double cx = center.x;
        double cy = center.y;
        double cz = center.z;
        for (int i = 0; i < points; ++i) {
            double a = Math.PI * 2 * (double)i / (double)points;
            double px = cx + (double)radius * Math.cos(a);
            double pz = cz + (double)radius * Math.sin(a);
            level.sendParticles((ParticleOptions)dust, px, cy, pz, 1, 0.04, 0.04, 0.04, 0.0);
        }
    }

    private void spawnLingeringCloud(ServerLevel level, Vec3 center, float seconds, float startRadius) {
        int duration = (int)(seconds * 20.0f);
        AreaEffectCloud cloud = new AreaEffectCloud((Level)level, center.x, center.y + 0.1, center.z);
        cloud.setParticle((ParticleOptions)RED_DEEP);
        cloud.setDuration(duration);
        cloud.setRadius(startRadius);
        cloud.setRadiusPerTick(-(startRadius * 0.6f) / (float)duration);
        cloud.setWaitTime(0);
        cloud.setNoGravity(true);
        level.addFreshEntity((Entity)cloud);
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private static float easeOutCubic(float x) {
        float inv = 1.0f - x;
        return 1.0f - inv * inv * inv;
    }

    private static int scaledCount(int base) {
        return Math.max(1, Math.round((float)base * 1.0f));
    }
}

