/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.item.gear;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.trique.gemforged.entity.ThunderPrismEntity;

public class ThunderPrismItem
extends Item {
    public ThunderPrismItem(Item.Properties props) {
        super(props.durability(250));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            if (player.getCooldowns().isOnCooldown((Item)this)) {
                return InteractionResultHolder.fail((Object)stack);
            }
            level.playSound(null, player.blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 0.9f, 0.6f + level.random.nextFloat() * 0.2f);
            ItemStack prismStack = stack.copy();
            prismStack.setCount(1);
            ThunderPrismEntity prism = new ThunderPrismEntity(level, player.getX(), player.getY() + 1.0, player.getZ(), player);
            prism.setItem(prismStack);
            level.addFreshEntity((Entity)prism);
            player.getCooldowns().addCooldown((Item)this, 600);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }
}

