/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.item.gear;

import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class VenomfangBladeItem
extends SwordItem {
    private static final int HIT_THRESHOLD = 3;
    private static final int SUPER_THRESHOLD = 10;
    private static final float MAGIC_DAMAGE = 3.0f;
    private static final float WAVE_MAX_RADIUS = 7.0f;
    private static final int WAVE_FRAMES = 16;
    private static final int WAVE_FRAME_STEP = 2;
    private static final int WAVE_COUNT = 3;
    private static final int WAVE_GAP_TICKS = 6;
    private static final int POISON_DURATION = 200;
    private static final int WITHER_DURATION = 200;
    private static final double KNOCKBACK_STRENGTH = 1.5;
    private static final double KNOCKBACK_VERTICAL = 0.25;
    private static final Vector3f MALACHITE = new Vector3f(0.25f, 0.9f, 0.6f);
    private static final float MALACHITE_SCALE = 1.8f;
    private static final Vector3f DARK_GREEN = new Vector3f(0.1f, 0.35f, 0.1f);
    private static final Vector3f PURPLE_LAVENDER = new Vector3f(0.55f, 0.25f, 0.65f);
    private static final float DARK_SCALE = 2.1f;

    public VenomfangBladeItem(Item.Properties props) {
        super((Tier)Tiers.IRON, props.attributes(SwordItem.createAttributes((Tier)Tiers.DIAMOND, (int)1, (float)-2.0f)));
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        boolean res = super.hurtEnemy(stack, target, attacker);
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (!player.level().isClientSide) {
                int superCount;
                CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
                CompoundTag tag = data.copyTag();
                int count = tag.getInt("venomfang_hits") + 1;
                if (count >= 3) {
                    this.triggerVenomWaves((ServerLevel)player.level(), player, target);
                    count = 0;
                }
                if ((superCount = tag.getInt("venomfang_super") + 1) >= 10) {
                    this.triggerWitherBlast((ServerLevel)player.level(), player, target);
                    superCount = 0;
                }
                tag.putInt("venomfang_hits", count);
                tag.putInt("venomfang_super", superCount);
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            }
        }
        return res;
    }

    private void triggerVenomWaves(ServerLevel level, Player attacker, LivingEntity source) {
        Vec3 center = source.position().add(0.0, 0.05, 0.0);
        level.playSound(null, center.x, center.y, center.z, SoundEvents.WITCH_DRINK, SoundSource.PLAYERS, 0.9f, 0.95f);
        level.playSound(null, center.x, center.y, center.z, SoundEvents.BREWING_STAND_BREW, SoundSource.PLAYERS, 0.9f, 1.25f);
        int start = level.getServer().getTickCount();
        for (int w = 0; w < 3; ++w) {
            int waveStart = start + w * 6;
            level.getServer().tell((Runnable)new TickTask(waveStart, () -> {
                level.playSound(null, center.x, center.y, center.z, SoundEvents.SLIME_SQUISH, SoundSource.PLAYERS, 0.75f, 0.8f);
                level.playSound(null, center.x, center.y, center.z, SoundEvents.SPIDER_AMBIENT, SoundSource.PLAYERS, 0.6f, 0.55f);
            }));
            for (int f = 0; f <= 16; ++f) {
                int when = waveStart + f * 2;
                float t = (float)f / 16.0f;
                float rad = t * 7.0f;
                float fade = 1.0f - t;
                Vec3 cNow = center;
                level.getServer().tell((Runnable)new TickTask(when, () -> this.spawnRingWithSpikes(level, cNow, rad, 2.0, fade)));
            }
        }
        AABB box = AABB.ofSize((Vec3)center, (double)14.0, (double)3.0, (double)14.0);
        for (LivingEntity e : level.getEntitiesOfClass(LivingEntity.class, box, le -> le.isAlive() && le != attacker)) {
            e.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 0));
            e.hurt(level.damageSources().indirectMagic((Entity)attacker, (Entity)attacker), 3.0f);
            Vec3 diff = e.position().subtract(center);
            Vec3 push = new Vec3(diff.x, 0.0, diff.z).normalize().scale(1.5);
            e.push(push.x, 0.25, push.z);
            e.hurtMarked = true;
        }
        level.getServer().tell((Runnable)new TickTask(start + 18 + 32, () -> level.playSound(null, center.x, center.y, center.z, SoundEvents.WITCH_THROW, SoundSource.PLAYERS, 0.6f, 1.35f)));
    }

    private void triggerWitherBlast(ServerLevel level, Player attacker, LivingEntity source) {
        Vec3 center = source.position().add(0.0, 0.05, 0.0);
        level.playSound(null, center.x, center.y, center.z, SoundEvents.WITHER_AMBIENT, SoundSource.PLAYERS, 1.2f, 0.9f);
        int start = level.getServer().getTickCount();
        for (int f = 0; f <= 16; ++f) {
            int when = start + f * 2;
            float t = (float)f / 16.0f;
            float rad = t * 7.0f;
            float fade = 1.0f - t;
            Vec3 cNow = center;
            level.getServer().tell((Runnable)new TickTask(when, () -> {
                this.spawnRingWithSpikesColored(level, cNow, rad, 2.0, fade, DARK_GREEN, 2.1f);
                this.spawnRingWithSpikesColored(level, cNow, rad, 2.0, fade, PURPLE_LAVENDER, 2.1f);
            }));
        }
        AABB box = AABB.ofSize((Vec3)center, (double)14.0, (double)3.0, (double)14.0);
        for (LivingEntity e : level.getEntitiesOfClass(LivingEntity.class, box, le -> le.isAlive() && le != attacker)) {
            e.addEffect(new MobEffectInstance(MobEffects.WITHER, 200, 0));
            e.hurt(level.damageSources().indirectMagic((Entity)attacker, (Entity)attacker), 6.0f);
        }
        level.getServer().tell((Runnable)new TickTask(start + 32 + 6, () -> level.playSound(null, center.x, center.y, center.z, SoundEvents.WARDEN_HEARTBEAT, SoundSource.PLAYERS, 0.6f, 0.8f)));
    }

    private void spawnRingWithSpikes(ServerLevel level, Vec3 center, float radius, double height, float fade) {
        this.spawnRingWithSpikesColored(level, center, radius, height, fade, MALACHITE, 1.8f);
    }

    private void spawnRingWithSpikesColored(ServerLevel level, Vec3 center, float radius, double height, float fade, Vector3f color, float scale) {
        double pz;
        double px;
        double a;
        if (radius <= 0.05f) {
            return;
        }
        double cx = center.x;
        double cy = center.y;
        double cz = center.z;
        float r01 = Math.min(1.0f, radius / 7.0f);
        float density = 0.25f + (float)Math.pow(r01, 1.6);
        int points = Math.max(12, (int)(radius * 18.0f * density));
        int layers = 8;
        DustParticleOptions dust = new DustParticleOptions(color, scale * (0.8f + 0.5f * fade));
        for (int i = 0; i < points; ++i) {
            a = Math.PI * 2 * (double)i / (double)points;
            px = cx + (double)radius * Math.cos(a);
            pz = cz + (double)radius * Math.sin(a);
            double py = cy + height * 0.5;
            level.sendParticles((ParticleOptions)dust, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (radius >= 2.45f) {
            for (int k = 0; k < 8; ++k) {
                a = 0.7853981633974483 * (double)k;
                px = cx + (double)radius * Math.cos(a);
                pz = cz + (double)radius * Math.sin(a);
                for (int h = 0; h <= layers; ++h) {
                    double py = cy + (double)h / (double)layers * height;
                    level.sendParticles((ParticleOptions)dust, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

