/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.util;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.trique.gemforged.item.GemforgedItems;

public final class GemforgedLootTableModifiers {
    private static final ResourceLocation WOODLAND_MANSION = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/woodland_mansion");
    private static final ResourceLocation PILLAGER_OUTPOST = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/pillager_outpost");
    private static final ResourceLocation DESERT_PYRAMID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/desert_pyramid");
    private static final ResourceLocation JUNGLE_TEMPLE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/jungle_temple");
    private static final ResourceLocation NETHER_BRIDGE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/nether_bridge");
    private static final ResourceLocation ANCIENT_CITY = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/ancient_city");

    private GemforgedLootTableModifiers() {
    }

    public static void register() {
        NeoForge.EVENT_BUS.addListener(GemforgedLootTableModifiers::onLootTableLoad);
    }

    private static LootPool makePoolWithChance(LootPoolEntryContainer.Builder<?> entryBuilder, float chance) {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(entryBuilder.when(LootItemRandomChanceCondition.randomChance((float)chance))).build();
    }

    private static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation id = event.getName();
        if (id == null) {
            return;
        }
        if (id.equals((Object)WOODLAND_MANSION)) {
            event.getTable().addPool(GemforgedLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)GemforgedItems.ONYX.get())), 0.25f));
        } else if (id.equals((Object)PILLAGER_OUTPOST)) {
            event.getTable().addPool(GemforgedLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)GemforgedItems.GARNET.get())), 0.2f));
        } else if (id.equals((Object)DESERT_PYRAMID)) {
            event.getTable().addPool(GemforgedLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)GemforgedItems.CITRINE.get())), 0.1f));
        } else if (id.equals((Object)JUNGLE_TEMPLE)) {
            event.getTable().addPool(GemforgedLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)GemforgedItems.MALACHITE.get())), 0.2f));
        } else if (id.equals((Object)NETHER_BRIDGE)) {
            event.getTable().addPool(GemforgedLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)GemforgedItems.CARNELIAN.get())), 0.1f));
        } else if (id.equals((Object)ANCIENT_CITY)) {
            event.getTable().addPool(GemforgedLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)GemforgedItems.ZIRCON.get())), 0.1f));
        }
    }
}

