/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.item.gear;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.trique.gemforged.item.GemforgedItems;
import org.joml.Vector3f;

public class SandburstStaffItem
extends Item {
    private static final float MAX_RADIUS = 10.0f;
    private static final float BASE_KNOCKBACK = 16.0f;
    private static final double VERTICAL_BOOST = 1.0;
    private static final int COOLDOWN_TICKS = 400;
    private static final float MAGIC_DAMAGE = 5.5f;
    private static final int USE_DURATION_TICKS = 20;
    private static final Vector3f CITRINE_MIX = new Vector3f(0.95f, 0.9f, 0.6f);
    private static final Vector3f CITRINE_DEEP = new Vector3f(1.0f, 0.75f, 0.25f);
    private static final float CITRINE_SCALE_SOFT = 1.6f;
    private static final float CITRINE_SCALE_DEEP = 2.0f;
    private static final int WAVE_COUNT = 3;
    private static final int WAVE_FRAMES = 16;
    private static final int WAVE_FRAME_STEP = 2;
    private static final int WAVE_GAP_TICKS = 4;
    private static final float MIN_RENDER_RADIUS = 0.8f;
    private static final float RINGS_HEIGHT = 2.0f;

    public SandburstStaffItem(Item.Properties props) {
        super(props.durability(250));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        if (!level.isClientSide) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 0.75f, 1.25f);
        }
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 20;
    }

    public void onUseTick(Level level, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (level.isClientSide) {
            return;
        }
        int elapsed = this.getUseDuration(stack, user) - remainingUseTicks;
        if (elapsed == 1) {
            level.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 0.7f, 1.05f);
        }
        if (elapsed % 5 == 0) {
            float pitch = 0.9f + (float)elapsed / 20.0f * 0.5f;
            level.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.AMETHYST_BLOCK_RESONATE, SoundSource.PLAYERS, 0.35f, pitch);
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        if (!level.isClientSide && user instanceof Player) {
            Player player = (Player)user;
            boolean creative = player.getAbilities().instabuild;
            ItemStack chargeResource = this.findChargeResource(player);
            if (creative || !chargeResource.isEmpty()) {
                this.triggerBurst((ServerLevel)level, player);
                if (!creative) {
                    chargeResource.shrink(1);
                    player.getCooldowns().addCooldown((Item)this, 400);
                    stack.hurtAndBreak(1, user, EquipmentSlot.MAINHAND);
                }
            }
        }
        return super.finishUsingItem(stack, level, user);
    }

    private ItemStack findChargeResource(Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack s = player.getInventory().getItem(i);
            if (!s.is((Item)GemforgedItems.SOLARIUM.get())) continue;
            return s;
        }
        return ItemStack.EMPTY;
    }

    private void triggerBurst(ServerLevel server, Player player) {
        Vec3 origin = player.position().add(0.0, 0.2, 0.0);
        server.playSound(null, origin.x, origin.y, origin.z, (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.PLAYERS, 0.6f, 1.55f);
        server.playSound(null, origin.x, origin.y, origin.z, SoundEvents.SAND_BREAK, SoundSource.PLAYERS, 1.2f, 0.85f);
        this.scheduleWaves(server, origin);
        this.affectEntities(server, player);
    }

    private void scheduleWaves(ServerLevel server, Vec3 center) {
        int start = server.getServer().getTickCount();
        for (int w = 0; w < 3; ++w) {
            int waveStart = start + w * 4;
            for (int f = 0; f <= 16; f += 2) {
                int when = waveStart + f;
                float t = (float)f / 16.0f;
                float eased = (float)Math.pow(t, 0.6);
                float rad = 0.8f + eased * 9.2f;
                float fade = 1.0f - t;
                Vec3 cNow = center;
                server.getServer().tell((Runnable)new TickTask(when, () -> {
                    this.spawnRingWithSpikesColored(server, cNow, rad, 2.0, fade, CITRINE_MIX, 1.6f);
                    this.spawnRingWithSpikesColored(server, cNow, rad, 2.0, fade, CITRINE_DEEP, 2.0f);
                }));
            }
        }
    }

    private void spawnRingWithSpikesColored(ServerLevel level, Vec3 center, float radius, double height, float fade, Vector3f color, float scale) {
        double pz;
        double px;
        double a;
        if (radius <= 0.8f) {
            return;
        }
        double cx = center.x;
        double cy = center.y;
        double cz = center.z;
        float r01 = Math.min(1.0f, radius / 10.0f);
        float density = 0.25f + (float)Math.pow(r01, 1.6);
        int points = Math.max(12, (int)(radius * 18.0f * density));
        int layers = 8;
        DustParticleOptions dust = new DustParticleOptions(color, scale * (0.8f + 0.5f * fade));
        for (int i = 0; i < points; ++i) {
            a = Math.PI * 2 * (double)i / (double)points;
            px = cx + (double)radius * Math.cos(a);
            pz = cz + (double)radius * Math.sin(a);
            double py = cy + height * 0.5;
            level.sendParticles((ParticleOptions)dust, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (radius >= 3.5f) {
            for (int k = 0; k < 8; ++k) {
                a = 0.7853981633974483 * (double)k;
                px = cx + (double)radius * Math.cos(a);
                pz = cz + (double)radius * Math.sin(a);
                for (int h = 0; h <= layers; ++h) {
                    double py = cy + (double)h / (double)layers * height;
                    level.sendParticles((ParticleOptions)dust, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private void affectEntities(ServerLevel server, Player source) {
        Vec3 center = source.position();
        AABB box = new AABB(center.x - 10.0, center.y - 1.0, center.z - 10.0, center.x + 10.0, center.y + 2.5, center.z + 10.0);
        for (Entity e : server.getEntities((Entity)source, box)) {
            if (e == source || !e.isPushable()) continue;
            Vec3 diff = e.position().subtract(center);
            Vec3 horizontal = new Vec3(diff.x, 0.0, diff.z);
            double dist = horizontal.length();
            if (dist <= 1.0E-4 || dist > 10.0) continue;
            double falloff = Math.max(0.0, 1.0 - dist / 10.0);
            double strength = 16.0 * falloff;
            Vec3 push = horizontal.normalize().scale(strength);
            e.push(push.x, 1.0 * falloff, push.z);
            e.hurtMarked = true;
            if (!(e instanceof LivingEntity)) continue;
            LivingEntity le = (LivingEntity)e;
            le.hurt(server.damageSources().indirectMagic((Entity)source, (Entity)source), 5.5f);
        }
    }
}

