/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.util;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.trique.gemforged.item.GemforgedItems;

public final class GemforgedLootTableModifiers {
    private static final ResourceLocation ANCIENT_CITY_CHEST = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/ancient_city");
    private static final ResourceLocation BASTION_BRIDGE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/bastion_bridge");
    private static final ResourceLocation BASTION_HOGLIN = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/bastion_hoglin_stable");
    private static final ResourceLocation BASTION_OTHER = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/bastion_other");
    private static final ResourceLocation BASTION_TREASURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/bastion_treasure");
    private static final ResourceLocation DESERT_PYRAMID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/desert_pyramid");
    private static final ResourceLocation JUNGLE_TEMPLE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/jungle_temple");
    private static final ResourceLocation END_CITY_TREASURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"chests/end_city_treasure");
    private static final ResourceLocation OCEAN_RUIN_COLD_ARCH = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"archaeology/ocean_ruin_cold");

    private GemforgedLootTableModifiers() {
    }

    public static void register() {
        NeoForge.EVENT_BUS.addListener(GemforgedLootTableModifiers::onLootTableLoad);
    }

    private static LootPool makePoolWithChance(LootPoolEntryContainer.Builder<?> entryBuilder, float chance) {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(entryBuilder.when(LootItemRandomChanceCondition.randomChance((float)chance))).build();
    }

    private static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation id = event.getName();
        if (id == null) {
            return;
        }
        if (id.equals((Object)ANCIENT_CITY_CHEST)) {
            event.getTable().addPool(GemforgedLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)GemforgedItems.DAGGER_TEMPLATE.get())), 0.25f));
        } else if (id.equals((Object)BASTION_BRIDGE) || id.equals((Object)BASTION_HOGLIN) || id.equals((Object)BASTION_OTHER)) {
            event.getTable().addPool(GemforgedLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)GemforgedItems.CHARM_TEMPLATE.get())), 0.25f));
        } else if (id.equals((Object)BASTION_TREASURE)) {
            event.getTable().addPool(GemforgedLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)GemforgedItems.CHARM_TEMPLATE.get())), 0.5f));
        } else if (id.equals((Object)DESERT_PYRAMID)) {
            event.getTable().addPool(GemforgedLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)GemforgedItems.STAFF_TEMPLATE.get())), 0.1f));
        } else if (id.equals((Object)JUNGLE_TEMPLE)) {
            event.getTable().addPool(GemforgedLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)GemforgedItems.BLADE_TEMPLATE.get())), 0.25f));
        } else if (id.equals((Object)OCEAN_RUIN_COLD_ARCH)) {
            event.getTable().addPool(GemforgedLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)GemforgedItems.PRISM_TEMPLATE.get())), 0.25f));
        } else if (id.equals((Object)END_CITY_TREASURE)) {
            event.getTable().addPool(GemforgedLootTableModifiers.makePoolWithChance(LootItem.lootTableItem((ItemLike)((ItemLike)GemforgedItems.HORN_TEMPLATE.get())), 0.25f));
        }
    }
}

