/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.worldgen;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.trique.gemforged.block.GemforgedBlocks;

public class GemforgedConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> NYXITE_ORE_KEY = GemforgedConfiguredFeatures.registerKey("nyxite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLOODSTONE_ORE_KEY = GemforgedConfiguredFeatures.registerKey("bloodstone_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SOLARIUM_ORE_KEY = GemforgedConfiguredFeatures.registerKey("solarium_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VENOMYTE_ORE_KEY = GemforgedConfiguredFeatures.registerKey("venomyte_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PHOENIXTONE_ORE_KEY = GemforgedConfiguredFeatures.registerKey("phoenixtone_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PRISMYTE_ORE_KEY = GemforgedConfiguredFeatures.registerKey("prismyte_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GRAVITIUM_ORE_KEY = GemforgedConfiguredFeatures.registerKey("gravitium_ore");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> nyxiteTargets = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)GemforgedBlocks.NYXITE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)GemforgedBlocks.DEEPSLATE_NYXITE_ORE.get()).defaultBlockState()));
        GemforgedConfiguredFeatures.register(context, NYXITE_ORE_KEY, Feature.ORE, new OreConfiguration(nyxiteTargets, 5));
        List<OreConfiguration.TargetBlockState> bloodstoneTargets = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)GemforgedBlocks.BLOODSTONE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)GemforgedBlocks.DEEPSLATE_BLOODSTONE_ORE.get()).defaultBlockState()));
        GemforgedConfiguredFeatures.register(context, BLOODSTONE_ORE_KEY, Feature.ORE, new OreConfiguration(bloodstoneTargets, 5));
        List<OreConfiguration.TargetBlockState> solariumTargets = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)GemforgedBlocks.SOLARIUM_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)GemforgedBlocks.DEEPSLATE_SOLARIUM_ORE.get()).defaultBlockState()));
        GemforgedConfiguredFeatures.register(context, SOLARIUM_ORE_KEY, Feature.ORE, new OreConfiguration(solariumTargets, 5));
        List<OreConfiguration.TargetBlockState> venomyteTargets = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)GemforgedBlocks.VENOMYTE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)GemforgedBlocks.DEEPSLATE_VENOMYTE_ORE.get()).defaultBlockState()));
        GemforgedConfiguredFeatures.register(context, VENOMYTE_ORE_KEY, Feature.ORE, new OreConfiguration(venomyteTargets, 5));
        List<OreConfiguration.TargetBlockState> phoenixtoneTargets = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)GemforgedBlocks.PHOENIXTONE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)GemforgedBlocks.DEEPSLATE_PHOENIXTONE_ORE.get()).defaultBlockState()));
        GemforgedConfiguredFeatures.register(context, PHOENIXTONE_ORE_KEY, Feature.ORE, new OreConfiguration(phoenixtoneTargets, 5));
        List<OreConfiguration.TargetBlockState> prismyteTargets = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)GemforgedBlocks.PRISMYTE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)GemforgedBlocks.DEEPSLATE_PRISMYTE_ORE.get()).defaultBlockState()));
        GemforgedConfiguredFeatures.register(context, PRISMYTE_ORE_KEY, Feature.ORE, new OreConfiguration(prismyteTargets, 5));
        List<OreConfiguration.TargetBlockState> gravitiumTargets = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)GemforgedBlocks.GRAVITIUM_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)GemforgedBlocks.DEEPSLATE_GRAVITIUM_ORE.get()).defaultBlockState()));
        GemforgedConfiguredFeatures.register(context, GRAVITIUM_ORE_KEY, Feature.ORE, new OreConfiguration(gravitiumTargets, 5));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gemforged", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

