package net.trique.gemforged.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import net.trique.gemforged.effect.GemforgedEffects;

public class RageOverlay implements HudRenderCallback {
    private static final float BASE_ALPHA = 0.32f;
    private static final float PULSE_ALPHA = 0.16f;
    private static final int PERIOD_TICKS = 30;
    private static final int RED_RGB = 0x00FF0000;

    @Override
    public void onHudRender(class_332 context, float tickDelta) {
        class_310 mc = class_310.method_1551();
        class_1657 player = mc.field_1724;
        if (player == null || mc.field_1690.method_31044().method_31034() == false) return;
        class_1291 rageEffect = class_7923.field_41174.method_10223(GemforgedEffects.RAGE_ID);
        if (rageEffect == null) return;
        class_1293 eff = player.method_6112(rageEffect);
        if (eff == null) return;
        long gt = player.method_37908().method_8510();
        float phase = (gt % PERIOD_TICKS) / (float) PERIOD_TICKS;
        float alpha = BASE_ALPHA + PULSE_ALPHA * class_3532.method_15374(phase * (float) (Math.PI * 2));
        alpha = class_3532.method_15363(alpha, 0f, 1f);
        int width = mc.method_22683().method_4486();
        int height = mc.method_22683().method_4502();
        int a = class_3532.method_15340(Math.round(alpha * 255f), 0, 255);
        int color = (a << 24) | RED_RGB;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        context.method_25294(0, 0, width, height, color);
        RenderSystem.disableBlend();
    }

    public static void register() {
        HudRenderCallback.EVENT.register(new RageOverlay());
    }
}