package net.trique.gemforged.effect;

import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_2390;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4081;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import org.joml.Vector3f;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PhoenixEffect extends class_1291 {
    private static final double BASE_MOVE_MULT = 0.25D;
    private static final UUID MOVE_UUID = UUID.fromString("cc6d29f1-8c8a-4b12-9b1e-8fb45026a781");
    private static final Map<UUID, SavedState> STATES = new HashMap<>();

    private static final class_2390 RED =
            new class_2390(new Vector3f(1.00f, 0.05f, 0.02f), 2.0f);
    private static final class_2390 ORANGE =
            new class_2390(new Vector3f(0.7725f, 0.2353f, 0.0627f), 2.0f);
    private static final class_2390 YELLOW =
            new class_2390(new Vector3f(0.9725f, 0.7294f, 0.3843f), 2.0f);

    public PhoenixEffect() {
        super(class_4081.field_18271, 0xFF7A00);
        this.method_5566(class_5134.field_23719, MOVE_UUID.toString(),
                BASE_MOVE_MULT, class_1322.class_1323.field_6331);

        ServerLivingEntityEvents.ALLOW_DEATH.register((entity, source, amount) -> {
            if (entity instanceof class_1657 player && player.method_6059(GemforgedEffects.PHOENIX)) {
                if (PhoenixEffect.tryRevive(player)) return false;
            }
            return true;
        });
    }

    @Override
    public void method_5555(class_1309 entity, class_5131 attributes, int amplifier) {
        if (entity instanceof class_1657 player) {
            class_243 pos = player.method_19538();
            STATES.put(player.method_5667(),
                    new SavedState(pos, player.method_36454(), player.method_36455(), player.method_6032()));
        }
    }

    @Override
    public void method_5562(class_1309 entity, class_5131 attributes, int amplifier) {
        if (entity instanceof class_1657 player) {
            STATES.remove(player.method_5667());
        }
    }

    @Override
    public boolean method_5552(int duration, int amplifier) {
        return true;
    }

    @Override
    public void method_5572(class_1309 entity, int amplifier) {
        if (!(entity.method_37908() instanceof class_3218 level)) return;

        class_243 look = entity.method_5828(1.0f);
        class_243 pos = entity.method_19538();

        double speed = entity.method_18798().method_1033();
        int densityBoost = (int) Math.min(10, Math.floor(speed * 25.0));
        int perSegParticles = 6 + densityBoost;
        int segments = 3;
        double segStep = 0.5;

        double backDist = 0.75 + entity.method_6051().method_43058() * 0.35;
        double baseX = pos.field_1352 - look.field_1352 * backDist;
        double baseY = pos.field_1351 + 0.55;
        double baseZ = pos.field_1350 - look.field_1350 * backDist;

        class_243 up = new class_243(0, 1, 0);
        class_243 side = up.method_1036(look).method_1029();
        class_243 upTilt = look.method_1036(side).method_1029();

        for (int s = 0; s < segments; s++) {
            double tBack = s * segStep;
            double cx = baseX - look.field_1352 * tBack;
            double cy = baseY - 0.05 * s;
            double cz = baseZ - look.field_1350 * tBack;

            double r = 0.24 + 0.06 * s;

            for (int i = 0; i < perSegParticles; i++) {
                double a = (Math.PI * 2 * i) / perSegParticles + entity.field_6012 * 0.28;
                class_243 offset = side.method_1021(r * class_3532.method_15362((float) a))
                        .method_1019(upTilt.method_1021(r * class_3532.method_15374((float) a) * 1.8));

                double px = cx + offset.field_1352;
                double py = cy + offset.field_1351;
                double pz = cz + offset.field_1350;

                int sel = (s + i) % 3;
                class_2390 dust = (sel == 0) ? RED : (sel == 1) ? ORANGE : YELLOW;
                level.method_14199(dust, px, py, pz, 1, 0, 0, 0, 0);
            }
        }

        if (entity.field_6012 % 50 == 0) {
            level.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350,
                    class_3417.field_14970, class_3419.field_15248,
                    0.5f, 0.10f + entity.method_6051().method_43057() * 0.20f);
        }
    }

    public static boolean tryRevive(class_1657 player) {
        SavedState state = STATES.get(player.method_5667());
        if (state == null) return false;

        player.method_6033(state.health);

        if (player instanceof class_3222 sp) {
            class_3218 sw = (class_3218) sp.method_37908();
            sp.method_14251(sw, state.pos.field_1352, state.pos.field_1351, state.pos.field_1350, state.yaw, state.pitch);
        } else {
            player.method_5814(state.pos.field_1352, state.pos.field_1351, state.pos.field_1350);
            player.method_36456(state.yaw);
            player.method_36457(state.pitch);
        }

        STATES.remove(player.method_5667());
        player.method_6016(GemforgedEffects.PHOENIX);

        if (player.method_37908() instanceof class_3218 level) {
            class_243 pos = player.method_19538();

            level.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350,
                    class_3417.field_14917, class_3419.field_15248, 2.0f, 1.0f);
            level.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350,
                    class_3417.field_14734, class_3419.field_15248, 1.5f, 0.8f);

            int rings = 5;
            int pointsPerRing = 120;
            double maxRadius = 8.0;

            for (int r = 0; r < rings; r++) {
                double radius = (maxRadius / rings) * (r + 1);
                double yBase = pos.field_1351 + 0.3 + r * 0.2;

                for (int i = 0; i < pointsPerRing; i++) {
                    double angle = (Math.PI * 2 * i) / pointsPerRing;
                    double px = pos.field_1352 + radius * Math.cos(angle);
                    double pz = pos.field_1350 + radius * Math.sin(angle);
                    double py = yBase + Math.sin(i * 0.15 + r) * 0.2;

                    int selector = (i + r) % 3;
                    class_2390 dust = (selector == 0) ? RED : (selector == 1) ? ORANGE : YELLOW;
                    level.method_14199(dust, px, py, pz, 1, 0, 0, 0, 0);
                }
            }

            int columns = 16;
            for (int col = 0; col < columns; col++) {
                double angle = (Math.PI * 2 * col) / columns;
                double px = pos.field_1352 + Math.cos(angle) * 2.0;
                double pz = pos.field_1350 + Math.sin(angle) * 2.0;

                for (int h = 0; h < 20; h++) {
                    double py = pos.field_1351 + 0.2 + h * 0.15;
                    class_2390 dust = (h > 13) ? YELLOW : (h > 6) ? ORANGE : RED;
                    level.method_14199(dust, px, py, pz, 1, 0, 0, 0, 0);
                }
            }

            level.method_14199(class_2398.field_11236, pos.field_1352, pos.field_1351 + 1, pos.field_1350,
                    3, 1.0, 1.0, 1.0, 0.0);
        }

        return true;
    }

    private record SavedState(class_243 pos, float yaw, float pitch, float health) {}
}