package net.trique.gemforged.entity;

import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1667;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3966;
import net.minecraft.entity.*;

public class GhostArrowEntity extends class_1667 {

    private static final int MAX_LIFETIME = 60;
    private int lifetime = 0;

    public GhostArrowEntity(class_1299<? extends GhostArrowEntity> type, class_1937 world) {
        super(type, world);
        init();
    }

    public GhostArrowEntity(class_1937 world, class_1309 owner) {
        super(world, owner);
        init();
    }

    private void init() {
        this.method_7433(true);
        this.field_7572 = class_1666.field_7592;
    }

    @Override
    public void method_5773() {

        // ✅ Super çağırmıyoruz, kendi physics’imiz
        class_243 vel = this.method_18798();

        if (!this.method_5740()) {
            vel = vel.method_1031(0.0D, -0.05D, 0.0D);
            this.method_18799(vel);
        }

        class_243 pos = this.method_19538();
        class_243 nextPos = pos.method_1019(vel);

        class_3966 hit = class_1675.method_18075(
                this,
                pos,
                nextPos,
                this.method_5829().method_18804(vel).method_1014(0.8D),
                e -> e instanceof class_1309
                        && e.method_5805()
                        && e != this.method_24921(),
                0
        );

        if (hit != null) {
            this.method_7454(hit);
            return;
        }

        // ✅ collision olmadan hareket
        this.method_5784(class_1313.field_6308, vel);

        // ✅ Yönü velocity ile güncelle
        this.method_36456((float)(Math.atan2(vel.field_1352, vel.field_1350) * 180.0D / Math.PI));
        this.method_36457((float)(Math.atan2(vel.field_1351, vel.method_37267()) * 180.0D / Math.PI));

        if (++lifetime >= MAX_LIFETIME && !method_37908().field_9236) {
            this.method_31472();
        }
    }

    @Override
    protected void method_7454(class_3966 hitResult) {
        super.method_7454(hitResult);
        if (!method_37908().field_9236) this.method_31472();
    }

    @Override
    protected class_1799 method_7445() {
        return new class_1799(class_1802.field_8162);
    }
}
