package net.trique.gemforged.entity;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1321;
import net.minecraft.class_1439;
import net.minecraft.class_1473;
import net.minecraft.class_1496;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3856;
import net.minecraft.entity.*;
import net.trique.gemforged.item.GemforgedItems;

import java.util.List;
import java.util.UUID;

public class ThunderPrismEntity extends class_1297 implements class_3856 {
    private int life;
    private class_1799 storedItem = class_1799.field_8037;
    private class_1657 owner;
    private UUID ownerId;
    private double originX, originZ, targetY;
    private double angle;
    private boolean spinning = false;

    public ThunderPrismEntity(class_1299<? extends ThunderPrismEntity> type, class_1937 world) {
        super(type, world);
        this.method_5875(true);
    }

    public ThunderPrismEntity(class_1937 world, double x, double y, double z, class_1657 owner) {
        this(GemforgedEntities.THUNDER_PRISM, world);
        this.method_23327(x, y, z);
        this.owner = owner;
        this.ownerId = owner.method_5667();
    }

    @Override
    public void method_5773() {
        super.method_5773();
        life++;

        if (life == 1) {
            originX = method_23317();
            originZ = method_23321();
            targetY = method_23318() + 4.5;
            if (!method_37908().field_9236) {
                method_37908().method_43128(null, method_23317(), method_23318(), method_23321(),
                        class_3417.field_15119, class_3419.field_15248, 0.9F, 0.7F);
            }
        }

        if (owner == null && ownerId != null && method_37908() instanceof class_3218 serverWorld) {
            class_1297 e = serverWorld.method_14190(ownerId);
            if (e instanceof class_1657 p) owner = p;
        }

        double dy = method_23318() < targetY ? 0.08 : 0.0;
        double speed = method_23318() < targetY ? 0.35 : 1.0;
        angle += speed;
        double radius = method_23318() < targetY ? 0.8 : 1.0;
        double desiredX = originX + Math.cos(angle) * radius;
        double desiredZ = originZ + Math.sin(angle) * radius;
        double dx = (desiredX - method_23317()) * 0.45;
        double dz = (desiredZ - method_23321()) * 0.45;

        method_18800(dx, dy, dz);
        method_5784(class_1313.field_6308, method_18798());

        if (life >= 40 && life < 100) {
            spinning = true;
            method_36456(method_36454() + 25);
        } else {
            spinning = false;
        }

        if (method_37908() instanceof class_3218 server) {
            int count = spinning ? 36 : 16;
            server.method_14199(class_2398.field_11215,
                    method_23317(), method_23318(), method_23321(),
                    count, 0.6, 0.6, 0.6, 0.05);
            server.method_14199(class_2398.field_29644,
                    method_23317(), method_23318(), method_23321(),
                    count / 2, 0.5, 0.5, 0.5, 0.01);
        }

        if (!method_37908().field_9236 && life < 100 && life % 18 == 0) {
            method_37908().method_43128(null, method_23317(), method_23318(), method_23321(),
                    class_3417.field_43154, class_3419.field_15248, 0.6F, 0.9F + method_37908().method_8409().method_43057() * 0.2F);
        }

        if (life == 100 && !method_37908().field_9236) {
            triggerEffect();
        }

        if (life > 120 && !method_37908().field_9236) {
            method_31472();
        }
    }

    private void triggerEffect() {
        class_238 area = method_5829().method_1014(16);
        List<class_1309> targets = method_37908().method_8390(class_1309.class, area, e -> e.method_5805() && !isAlly(e));

        for (class_1309 target : targets) {
            for (int i = 0; i < 3; i++) {
                class_1538 bolt = class_1299.field_6112.method_5883(method_37908());
                if (bolt != null) {
                    bolt.method_5808(target.method_23317(), target.method_23318(), target.method_23321(), 0.0F, 0.0F);
                    method_37908().method_8649(bolt);
                }
            }
        }

        method_37908().method_43128(null, method_23317(), method_23318(), method_23321(),
                class_3417.field_14865, class_3419.field_15248, 2.0F, 1.0F);
    }

    private boolean isAlly(class_1309 entity) {
        if (entity == owner) return true;
        if (owner != null && owner.method_5722(entity)) return true;
        if (entity instanceof class_1321 t && owner != null && t.method_35057() == owner) return true;
        if (entity instanceof class_1496 h && owner != null && h.method_6727() && owner.method_5667().equals(h.method_6139())) return true;
        return (entity instanceof class_1439 || entity instanceof class_1473);
    }

    @Override
    protected void method_5693() {}

    @Override
    protected void method_5749(class_2487 nbt) {
        if (nbt.method_10545("Item")) {
            storedItem = class_1799.method_7915(nbt.method_10562("Item"));
        }
        if (nbt.method_25928("Owner")) ownerId = nbt.method_25926("Owner");
        originX = nbt.method_10574("OX");
        originZ = nbt.method_10574("OZ");
        targetY = nbt.method_10574("TY");
        angle = nbt.method_10574("Ang");
        life = nbt.method_10550("Life");
    }

    @Override
    protected void method_5652(class_2487 nbt) {
        if (!storedItem.method_7960()) nbt.method_10566("Item", storedItem.method_7953(new class_2487()));
        if (ownerId != null) nbt.method_25927("Owner", ownerId);
        nbt.method_10549("OX", originX);
        nbt.method_10549("OZ", originZ);
        nbt.method_10549("TY", targetY);
        nbt.method_10549("Ang", angle);
        nbt.method_10569("Life", life);
    }

    public class_1799 getItem() {
        return storedItem.method_7960() ? new class_1799(GemforgedItems.THUNDER_PRISM) : storedItem;
    }

    public void setItem(class_1799 stack) {
        this.storedItem = stack;
    }

    public void setOwner(class_1657 player) {
        this.owner = player;
        this.ownerId = player == null ? null : player.method_5667();
    }

    @Override
    public class_1799 method_7495() {
        return null;
    }
}