package net.trique.gemforged.entity;

import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1321;
import net.minecraft.class_1439;
import net.minecraft.class_1473;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3856;
import net.minecraft.entity.*;
import net.trique.gemforged.item.GemforgedItems;
import org.joml.Vector3f;

import java.awt.*;
import java.util.List;
import java.util.UUID;

public class VerdantTotemEntity extends class_1297 implements class_3856 {
    private int life;
    private class_1799 storedItem = class_1799.field_8037;
    private class_1657 owner;
    private UUID ownerId;
    private double originX, originZ, targetY;
    private double angle;

    public VerdantTotemEntity(class_1299<? extends VerdantTotemEntity> type, class_1937 world) {
        super(type, world);
        this.method_5875(true);
    }

    public VerdantTotemEntity(class_1937 world, double x, double y, double z, class_1657 owner) {
        this(GemforgedEntities.VERDANT_TOTEM, world);
        this.method_23327(x, y, z);
        this.owner = owner;
        this.ownerId = owner.method_5667();
    }

    @Override
    public void method_5773() {
        super.method_5773();
        life++;

        if (life == 1) {
            originX = method_23317();
            originZ = method_23321();
            targetY = method_23318() + 4.0;
            if (!method_37908().field_9236) {
                method_37908().method_43128(null, method_23317(), method_23318(), method_23321(),
                        class_3417.field_15119, class_3419.field_15248, 1.0F, 0.7F);
            }
        }

        if (owner == null && ownerId != null && method_37908() instanceof class_3218 serverWorld) {
            class_1297 e = serverWorld.method_14190(ownerId);
            if (e instanceof class_1657 p) owner = p;
        }

        double dy = method_23318() < targetY ? 0.05 : 0.0;
        double speed = 0.35;
        angle += speed;
        double radius = 0.8;
        double desiredX = originX + Math.cos(angle) * radius;
        double desiredZ = originZ + Math.sin(angle) * radius;
        double dx = (desiredX - method_23317()) * 0.4;
        double dz = (desiredZ - method_23321()) * 0.4;

        method_18800(dx, dy, dz);
        method_5784(class_1313.field_6308, method_18798());
        method_36456(method_36454() + 8f);

        if (method_37908() instanceof class_3218 server) {
            if (life % 4 == 0) {
                server.method_14199(new class_2390(new Vector3f(0.2F, 0.9F, 0.2F), 1.0F),
                        method_23317(), method_23318() + 0.5, method_23321(),
                        4, 0.35, 0.35, 0.35, 0.01);
            }
            for (int i = 0; i < 6; i++) {
                double a = (Math.PI * 2 * i) / 6.0;
                double px = method_23317() + Math.cos(a) * 1.5;
                double pz = method_23321() + Math.sin(a) * 1.5;
                double py = method_23318() + 0.1 * Math.sin((life + i * 5) * 0.2);
                server.method_14199(class_2398.field_17741, px, py, pz, 1, 0, 0, 0, 0);
            }

            if (life % 20 == 0) applyRegen();
        }

        if (life == 200 && !method_37908().field_9236) explode();
        if (life > 220 && !method_37908().field_9236) method_31472();
    }

    private void applyRegen() {
        class_238 area = method_5829().method_1014(12);
        List<class_1309> allies = method_37908().method_8390(class_1309.class, area, this::isAlly);
        for (class_1309 e : allies) {
            e.method_6092(new class_1293(class_1294.field_5924, 60, 1, false, true, true));
        }
    }

    private void explode() {
        if (!(method_37908() instanceof class_3218 server)) return;

        for (int i = 0; i < 4; i++) {
            float pitch = 0.7F + (i * 0.1F);
            server.method_43128(null, method_23317(), method_23318(), method_23321(), class_3417.field_43154, class_3419.field_15248, 4.0F, pitch);
            server.method_43128(null, method_23317(), method_23318(), method_23321(), class_3417.field_26942, class_3419.field_15248, 4.0F, pitch);
            server.method_43128(null, method_23317(), method_23318(), method_23321(), class_3417.field_14931, class_3419.field_15248, 4.0F, pitch);
        }
        server.method_43128(null, method_23317(), method_23318(), method_23321(), class_3417.field_14703, class_3419.field_15248, 4.0F, 1.0F);

        for (int i = 0; i < 120; i++) {
            server.method_14199(new class_2390(new Vector3f(0.4F, 1.0F, 0.4F), 1.5F),
                    method_23317(), method_23318(), method_23321(), 1,
                    field_5974.method_43059(), field_5974.method_43059(), field_5974.method_43059(), 0.04);
        }

        int[] colors = {0x2e8109, 0x4ab60a, 0x73d20a, 0x9de50c, 0xd7ef05};
        int rings = 5, pointsPerRing = 64;
        double maxRadius = 8.0;

        for (int ring = 0; ring < rings; ring++) {
            double r = (maxRadius / rings) * (ring + 1);
            Color c = new Color(colors[ring]);
            Vector3f colorVec = new Vector3f(c.getRed() / 255f, c.getGreen() / 255f, c.getBlue() / 255f);

            for (int p = 0; p < pointsPerRing; p++) {
                double a = (2 * Math.PI * p) / pointsPerRing;

                double px = method_23317() + Math.cos(a) * r;
                double pz = method_23321() + Math.sin(a) * r;
                double py = method_23318();
                spawnColoredSet(server, px, py, pz, colorVec);

                double vy = method_23318() + Math.sin(a) * r;
                double vz = method_23321() + Math.cos(a) * r;
                double vx = method_23317();
                spawnColoredSet(server, vx, vy, vz, colorVec);

                double xx = method_23317() + Math.cos(a) * r;
                double yy = method_23318() + Math.sin(a) * r;
                double zz = method_23321();
                spawnColoredSet(server, xx, yy, zz, colorVec);
            }
        }

        class_238 area = method_5829().method_1014(12);
        List<class_1309> allies = method_37908().method_8390(class_1309.class, area, this::isAlly);
        for (class_1309 e : allies) {
            e.method_6092(new class_1293(class_1294.field_5915, 1, 4, false, true, true));
            e.method_6092(new class_1293(class_1294.field_5924, 100, 1, false, true, true));
        }
    }

    private void spawnColoredSet(class_3218 server, double x, double y, double z, Vector3f color) {
        server.method_14199(new class_2390(color, 1.3F),
                x, y, z, 10, 0, 0, 0, 0.015);
        server.method_14199(class_2398.field_17741, x, y, z, 8, 0, 0, 0, 0.015);
    }

    private boolean isAlly(class_1309 entity) {
        if (entity == owner) return true;
        if (owner != null && owner.method_5722(entity)) return true;
        if (entity instanceof class_1321 t && owner != null && t.method_35057() == owner) return true;
        if (entity instanceof class_1496 h && owner != null && h.method_6727() && owner.method_5667().equals(h.method_6139())) return true;
        return (entity instanceof class_1439 || entity instanceof class_1473);
    }

    @Override
    protected void method_5693() {}

    @Override
    protected void method_5749(class_2487 nbt) {
        if (nbt.method_10545("Item")) storedItem = class_1799.method_7915(nbt.method_10562("Item"));
        if (nbt.method_25928("Owner")) ownerId = nbt.method_25926("Owner");
        originX = nbt.method_10574("OX");
        originZ = nbt.method_10574("OZ");
        targetY = nbt.method_10574("TY");
        angle = nbt.method_10574("Ang");
        life = nbt.method_10550("Life");
    }

    @Override
    protected void method_5652(class_2487 nbt) {
        if (!storedItem.method_7960()) nbt.method_10566("Item", storedItem.method_7953(new class_2487()));
        if (ownerId != null) nbt.method_25927("Owner", ownerId);
        nbt.method_10549("OX", originX);
        nbt.method_10549("OZ", originZ);
        nbt.method_10549("TY", targetY);
        nbt.method_10549("Ang", angle);
        nbt.method_10569("Life", life);
    }

    @Override
    public class_1799 method_7495() {
        return storedItem.method_7960() ? new class_1799(GemforgedItems.VERDANT_TOTEM) : storedItem;
    }

    public void setItem(class_1799 stack) {
        this.storedItem = stack;
    }

    public void setOwner(class_1657 player) {
        this.owner = player;
        this.ownerId = player == null ? null : player.method_5667();
    }
}