package net.trique.gemforged.item.gear;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.trique.gemforged.entity.GemforgedEntities;
import net.trique.gemforged.entity.GhostArrowEntity;
import net.trique.gemforged.item.GemforgedItems;

public class GhostBowItem extends class_1753 {

    public static final float BASE_DAMAGE = 3.0F;
    public static final float BONUS_MAGIC_DAMAGE = 1.0F;
    public static final int COOLDOWN_TICKS = 100;

    public GhostBowItem(class_1793 settings) {
        super(settings.method_7895(240));
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 bow = user.method_5998(hand);
        if (!hasNyxite(user)) {
            return class_1271.method_22431(bow);
        }
        user.method_6019(hand);
        return class_1271.method_22428(bow);
    }

    private boolean hasNyxite(class_1657 player) {
        if (player.method_31549().field_7477) return true;
        return player.method_31548().method_7379(new class_1799(GemforgedItems.NYXITE));
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (!(user instanceof class_1657 player)) return;
        if (!hasNyxite(player)) return;

        int i = this.method_7881(stack) - remainingUseTicks;
        float power = method_7722(i);
        if (power < 0.1F) return;

        if (!world.field_9236) {

            GhostArrowEntity arrow = new GhostArrowEntity(GemforgedEntities.GHOST_ARROW, world);
            arrow.method_7432(player);

            arrow.method_23327(player.method_23317(), player.method_23320() - 0.1, player.method_23321());

            arrow.method_24919(player, player.method_36455(), player.method_36454(), 0.0F, power * 3.0F, 1.0F);

            arrow.method_7438(BASE_DAMAGE + BONUS_MAGIC_DAMAGE);
            if (power >= 1.0F) arrow.method_7439(true);

            world.method_8649(arrow);

            world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(),
                    class_3417.field_14600, class_3419.field_15248,
                    1.0F, 1.0F / (world.method_8409().method_43057() * 0.4F + 1.2F) + (power * 0.5F));

            if (!player.method_31549().field_7477) {
                consumeNyxite(player);
                stack.method_7956(1, player, p -> p.method_20235(class_1304.field_6173));
                player.method_7357().method_7906(this, COOLDOWN_TICKS);
            }
        }

        player.method_7259(class_3468.field_15372.method_14956(this));
    }

    private void consumeNyxite(class_1657 player) {
        for (int i = 0; i < player.method_31548().method_5439(); i++) {
            class_1799 slot = player.method_31548().method_5438(i);
            if (slot.method_31574(GemforgedItems.NYXITE)) {
                slot.method_7934(1);
                break;
            }
        }
    }

    @Override
    public int method_7881(class_1799 stack) {
        return 72000;
    }
}
