package net.trique.gemforged.item.gear;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.trique.gemforged.effect.GemforgedEffects;
import net.trique.gemforged.item.GemforgedItems;
import org.joml.Vector3f;

import java.util.List;

public class GlacialCharmItem extends class_1792 {

    private static final float RADIUS = 8f;
    private static final int COOLDOWN_TICKS = 20 * 30;
    private static final int USE_DURATION_TICKS = 20;
    private static final int DURATION_GFL = 20 * 15;
    private static final int AMP_GFL = 0;

    private static final class_2390 COL_LIGHT =
            new class_2390(new Vector3f(0xa4 / 255f, 0xe9 / 255f, 0xfb / 255f), 2.2f);
    private static final class_2390 COL_MID =
            new class_2390(new Vector3f(0x54 / 255f, 0xc5 / 255f, 0xf1 / 255f), 2.2f);
    private static final class_2390 COL_DARK =
            new class_2390(new Vector3f(0x22 / 255f, 0x78 / 255f, 0xbb / 255f), 2.2f);

    public GlacialCharmItem(class_1793 settings) {
        super(settings.method_7895(250));
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        user.method_6019(hand);

        if (!world.field_9236) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(),
                    class_3417.field_26980,
                    class_3419.field_15248, 0.7f, 0.4f);
        }
        return class_1271.method_22428(user.method_5998(hand));
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    @Override
    public int method_7881(class_1799 stack) {
        return USE_DURATION_TICKS;
    }

    @Override
    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (!world.field_9236 && user instanceof class_1657 player) {
            class_1799 resource = findChargeResource(player);
            boolean creative = player.method_31549().field_7477;

            if (creative || !resource.method_7960()) {
                activateGlacial((class_3218) world, player);

                player.method_7259(class_3468.field_15372.method_14956(this));

                if (!creative) {
                    resource.method_7934(1);
                    stack.method_7956(1, player, p -> p.method_20235(class_1304.field_6173));
                    player.method_7357().method_7906(this, COOLDOWN_TICKS);
                }
            }
        }
        return stack;
    }

    private class_1799 findChargeResource(class_1657 player) {
        for (int i = 0; i < player.method_31548().method_5439(); i++) {
            class_1799 s = player.method_31548().method_5438(i);
            if (s.method_31574(GemforgedItems.PRISMYTE)) return s;
        }
        return class_1799.field_8037;
    }

    private void activateGlacial(class_3218 world, class_1657 player) {
        class_243 center = player.method_19538();

        world.method_43128(null, center.field_1352, center.field_1351, center.field_1350,
                class_3417.field_15081, class_3419.field_15248, 1.6f, 0.4f);

        spawnSnowflakeCoreFractal(world, center);
        spawn3DAxisFlakes(world, center);
        spawnSphereRings(world, center);
        spawnCloud(world, center);
        applyGlacialFist(world, player, center);
    }

    private void applyGlacialFist(class_3218 world, class_1657 caster, class_243 c) {
        class_238 box = new class_238(c.field_1352 - RADIUS, c.field_1351 - RADIUS, c.field_1350 - RADIUS,
                c.field_1352 + RADIUS, c.field_1351 + RADIUS, c.field_1350 + RADIUS);

        List<class_1309> allies =
                world.method_8390(class_1309.class, box,
                        e -> e.method_5722(caster) || e == caster);

        for (class_1309 ally : allies) {
            ally.method_6092(new class_1293(
                    GemforgedEffects.GLACIAL_FIST,
                    DURATION_GFL,
                    AMP_GFL,
                    true,
                    true
            ));
        }
    }

    private static class_2390 pick(int i) {
        int m = i % 3;
        return m == 0 ? COL_LIGHT : (m == 1 ? COL_MID : COL_DARK);
    }

    private void spawnSnowflakeCoreFractal(class_3218 world, class_243 c) {
        int arms = 8;
        int segments = 12;
        double cx = c.field_1352, cy = c.field_1351 + 0.3, cz = c.field_1350;

        for (int arm = 0; arm < arms; arm++) {
            double base = arm * (Math.PI * 2 / arms);

            for (int i = 1; i <= segments; i++) {
                double t = (double) i / segments;
                double dist = t * (RADIUS * 0.85);
                class_2390 col = pick(i);

                double sx = cx + Math.cos(base) * dist;
                double sz = cz + Math.sin(base) * dist;

                world.method_14199(col, sx, cy, sz, 2, 0.01, 0.01, 0.01, 0.006);

                double branch = base + (i % 2 == 0 ? Math.PI / 8 : -Math.PI / 8);
                double bd = dist * 0.35;
                double bx = sx + Math.cos(branch) * bd;
                double bz = sz + Math.sin(branch) * bd;
                world.method_14199(col, bx, cy, bz, 1, 0.008, 0.008, 0.008, 0.004);
            }
        }
    }

    private void spawn3DAxisFlakes(class_3218 world, class_243 c) {
        int samples = 16;
        double cx = c.field_1352, cy = c.field_1351 + 0.3, cz = c.field_1350;

        for (int i = 1; i <= samples; i++) {
            double t = (double) i / samples;
            double d = t * RADIUS;
            class_2390 col = pick(i);

            world.method_14199(col, cx + d, cy, cz, 1, 0.01, 0.01, 0.01, 0.006);
            world.method_14199(col, cx - d, cy, cz, 1, 0.01, 0.01, 0.01, 0.006);
            world.method_14199(col, cx, cy + d, cz, 1, 0.01, 0.01, 0.01, 0.006);
            world.method_14199(col, cx, cy - d, cz, 1, 0.01, 0.01, 0.01, 0.006);
            world.method_14199(col, cx, cy, cz + d, 1, 0.01, 0.01, 0.01, 0.006);
            world.method_14199(col, cx, cy, cz - d, 1, 0.01, 0.01, 0.01, 0.006);
        }
    }

    private void spawnSphereRings(class_3218 world, class_243 c) {
        int rings = 2;
        int perRing = 64;
        double cx = c.field_1352, cy = c.field_1351 + 0.3, cz = c.field_1350;

        for (int r = 1; r <= rings; r++) {
            double rr = (RADIUS / rings) * r;

            for (int i = 0; i < perRing; i++) {
                double a = (2 * Math.PI * i) / perRing;
                class_2390 col = pick(i);

                double x1 = cx + Math.cos(a) * rr;
                double z1 = cz + Math.sin(a) * rr;
                world.method_14199(col, x1, cy, z1, 2, 0.02, 0.02, 0.02, 0.007);
            }
        }
    }

    private void spawnCloud(class_3218 world, class_243 c) {
        class_1295 cloud = new class_1295(world, c.field_1352, c.field_1351 + 0.1, c.field_1350);
        cloud.method_5608(COL_MID);
        cloud.method_5603(RADIUS);
        cloud.method_5604(30);
        cloud.method_5596(-0.15f);
        cloud.method_5875(true);
        world.method_8649(cloud);
    }
}
