package net.trique.gemforged.item.gear;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.trique.gemforged.item.GemforgedItems;
import net.trique.gemforged.particle.GemforgedParticles;

import java.util.HashSet;
import java.util.Set;

public class PhoenixfireStaffItem extends class_1792 {

    private static final float MAGIC_DAMAGE = 3.0F;
    private static final int FIRE_SECONDS = 3;
    private static final float EXPLOSION_POWER = 1.0F;
    private static final int COOLDOWN_TICKS = 20 * 20;
    private static final int RANGE = 20;
    private static final double ENTITY_HIT_RADIUS = 1.2D;
    private static final float PARTICLE_HEIGHT_OFFSET = 1.6F;
    private static final float VERTICAL_KNOCKBACK_MULTIPLIER = 0.5F;
    private static final float HORIZONTAL_KNOCKBACK_MULTIPLIER = 2.0F;

    public PhoenixfireStaffItem(class_1793 settings) {
        super(settings.method_7895(350));
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        user.method_6019(hand);
        return class_1271.method_22428(user.method_5998(hand));
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    @Override
    public int method_7881(class_1799 stack) {
        return 20;
    }

    @Override
    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        int elapsed = method_7881(stack) - remainingUseTicks;
        if (elapsed == 1) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(),
                    class_3417.field_26980, class_3419.field_15248, 2.0F, 1.2F);
        }
    }

    @Override
    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (!world.field_9236 && user instanceof class_1657 player) {

            boolean creative = player.method_31549().field_7477;
            class_1799 fuel = findFuel(player);

            if (creative || !fuel.method_7960()) {
                fireBeam((class_3218) world, user);

                if (!creative) {
                    fuel.method_7934(1);
                    player.method_7357().method_7906(this, COOLDOWN_TICKS);
                    stack.method_7956(1, player, p -> p.method_20235(class_1304.field_6173));
                }
            }
        }
        return stack;
    }

    private class_1799 findFuel(class_1657 player) {
        for (int i = 0; i < player.method_31548().method_5439(); i++) {
            class_1799 s = player.method_31548().method_5438(i);
            if (s.method_31574(GemforgedItems.PHOENIXTONE)) return s;
        }
        return class_1799.field_8037;
    }

    private void fireBeam(class_3218 world, class_1309 user) {

        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(),
                class_3417.field_14917, class_3419.field_15248, 4.0F, 1.0F);
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(),
                class_3417.field_15013, class_3419.field_15248, 4.0F, 1.0F);

        class_243 source = user.method_19538().method_1031(0, PARTICLE_HEIGHT_OFFSET, 0);
        class_243 target = source.method_1019(user.method_5828(1.0F).method_1021(RANGE));
        class_243 toTarget = target.method_1020(source);
        class_243 dir = toTarget.method_1029();

        Set<class_1309> hit = new HashSet<>();
        int steps = class_3532.method_15357(toTarget.method_1033()) + 10;

        for (int i = 1; i < steps; i++) {
            class_243 p = source.method_1019(dir.method_1021(i));

            world.method_14199(
                    GemforgedParticles.PHOENIX_BEAM,
                    p.field_1352, p.field_1351, p.field_1350,
                    1,
                    0.0, 0.0, 0.0,
                    0.0
            );

            class_2338 bp = class_2338.method_49638(p);
            for (class_1297 e : world.method_8335(user,
                    new class_238(bp).method_1014(ENTITY_HIT_RADIUS))) {
                if (e instanceof class_1309 living && living != user)
                    hit.add(living);
            }
        }

        for (class_1309 living : hit) {

            living.method_5643(world.method_48963().method_48831(), MAGIC_DAMAGE);
            living.method_5639(FIRE_SECONDS);

            world.method_8437(user,
                    living.method_23317(), living.method_23318(), living.method_23321(),
                    EXPLOSION_POWER,
                    class_1937.class_7867.field_40888
            );

            double resist = living.method_26825(class_5134.field_23718);
            double v = VERTICAL_KNOCKBACK_MULTIPLIER * (1.0 - resist);
            double h = HORIZONTAL_KNOCKBACK_MULTIPLIER * (1.0 - resist);
            living.method_5762(dir.field_1352 * h, dir.field_1351 * v, dir.field_1350 * h);
        }
    }
}