package net.trique.gemforged.item.gear;

import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1834;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.trique.gemforged.item.GemforgedItems;
import org.joml.Vector3f;

import java.util.UUID;

public class ShadowstepDaggerItem extends class_1829 {
    private static final String TAG_COMBO = "onyx_combo";
    private static final String TAG_LASTHIT = "onyx_last_hit";
    private static final int MAX_COMBO = 6;
    private static final int COMBO_TIMEOUT_TICKS = 60;
    private static final int COOLDOWN_TICKS = 20 * 30;
    private static final double TP_MIN = 2.0, TP_MAX = 3.0;

    private static final UUID MOD_DAMAGE_ID = UUID.nameUUIDFromBytes("gemforged_onyx_combo_damage".getBytes());
    private static final UUID MOD_SPEED_ID = UUID.nameUUIDFromBytes("gemforged_onyx_combo_speed".getBytes());

    private static final Vector3f SHADOW_PURPLE = new Vector3f(0.2627f, 0.1569f, 0.3843f);
    private static final Vector3f SHADOW_LIGHT = new Vector3f(0.4745f, 0.3294f, 0.6118f);

    public ShadowstepDaggerItem(FabricItemSettings settings) {
        super(class_1834.field_8923, 2, -2.0f, settings.method_7895(250));
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!(attacker instanceof class_1657 player)) return true;
        class_1937 world = player.method_37908();
        if (world.field_9236) return true;

        class_2487 tag = stack.method_7948();
        long now = world.method_8510();
        int combo = tag.method_10550(TAG_COMBO);
        long last = tag.method_10537(TAG_LASTHIT);

        if (combo > 0 && (now - last) > COMBO_TIMEOUT_TICKS) {
            combo = 0;
            removeComboModifiers(player);
        }

        if (player.method_7357().method_7904(this)) {
            removeComboModifiers(player);
            return true;
        }

        if (combo == 0) {
            class_1799 nyxite = findChargeResource(player);
            boolean creative = player.method_31549().field_7477;
            if (!creative && nyxite.method_7960()) {
                return true;
            }
        }

        if (player instanceof class_3222 sp && target.method_5805()) {
            tryTeleportAround((class_3218) world, sp, target);
        }

        combo++;
        tag.method_10569(TAG_COMBO, combo);
        tag.method_10544(TAG_LASTHIT, now);

        if (combo == 1) {
            addComboModifiers(player);
        }

        if (combo >= MAX_COMBO) {
            boolean creative = player.method_31549().field_7477;
            class_1799 nyxite = findChargeResource(player);

            if (creative || !nyxite.method_7960()) {
                if (!creative) nyxite.method_7934(1);
                player.method_7357().method_7906(this, COOLDOWN_TICKS);
            }

            tag.method_10569(TAG_COMBO, 0);
            removeComboModifiers(player);
        }

        stack.method_7980(tag);
        return true;
    }

    private class_1799 findChargeResource(class_1657 player) {
        for (int i = 0; i < player.method_31548().method_5439(); i++) {
            class_1799 s = player.method_31548().method_5438(i);
            if (s.method_31574(GemforgedItems.NYXITE)) return s;
        }
        return class_1799.field_8037;
    }

    private void addComboModifiers(class_1657 player) {
        class_1324 dmg = player.method_5996(class_5134.field_23721);
        class_1324 spd = player.method_5996(class_5134.field_23723);
        if (dmg != null && dmg.method_6199(MOD_DAMAGE_ID) == null) {
            dmg.method_26835(new class_1322(MOD_DAMAGE_ID, "onyx_damage_bonus", 2.0, class_1322.class_1323.field_6328));
        }
        if (spd != null && spd.method_6199(MOD_SPEED_ID) == null) {
            spd.method_26835(new class_1322(MOD_SPEED_ID, "onyx_speed_bonus", 10.0, class_1322.class_1323.field_6328));
        }
    }

    private void removeComboModifiers(class_1657 player) {
        class_1324 dmg = player.method_5996(class_5134.field_23721);
        class_1324 spd = player.method_5996(class_5134.field_23723);
        if (dmg != null) dmg.method_6200(MOD_DAMAGE_ID);
        if (spd != null) spd.method_6200(MOD_SPEED_ID);
    }

    private void tryTeleportAround(class_3218 world, class_3222 player, class_1309 target) {
        class_243 c = target.method_19538();
        class_5819 random = world.method_8409();

        for (int i = 0; i < 10; i++) {
            double d = TP_MIN + random.method_43058() * (TP_MAX - TP_MIN);
            double a = random.method_43058() * Math.PI * 2;

            class_2338 guess = class_2338.method_49637(
                    c.field_1352 + d * Math.cos(a),
                    c.field_1351,
                    c.field_1350 + d * Math.sin(a)
            );
            class_2338 safe = findStandable(world, guess, 6);
            if (safe != null) {
                class_243 from = player.method_19538();
                spawnShadowSmoke(world, from.field_1352, from.field_1351 + 1.0, from.field_1350);
                playShadowTeleportSound(world, from.field_1352, from.field_1351, from.field_1350);

                player.method_6082(safe.method_10263() + 0.5, safe.method_10264(), safe.method_10260() + 0.5, true);

                class_243 to = player.method_19538();
                spawnShadowSmoke(world, to.field_1352, to.field_1351 + 1.0, to.field_1350);
                playShadowTeleportSound(world, to.field_1352, to.field_1351, to.field_1350);
                player.method_5702(net.minecraft.class_2183.class_2184.field_9851, target.method_33571());
                return;
            }
        }
    }

    private void spawnShadowSmoke(class_3218 world, double x, double y, double z) {
        world.method_14199(new class_2390(SHADOW_PURPLE, 1.5f),
                x, y, z, 20, 0.6, 0.25, 0.6, 0.02);
        world.method_14199(new class_2390(SHADOW_LIGHT, 1.5f),
                x, y, z, 20, 0.6, 0.25, 0.6, 0.02);
        world.method_14199(class_2398.field_11237, x, y, z, 20, 0.6, 0.25, 0.6, 0.02);
        world.method_14199(class_2398.field_22247, x, y, z, 10, 0.5, 0.2, 0.5, 0.01);
    }

    private void playShadowTeleportSound(class_3218 world, double x, double y, double z) {
        world.method_43128(null, x, y, z, class_3417.field_14879, class_3419.field_15248, 1.0f, 0.6f + world.field_9229.method_43057() * 0.2f);
        world.method_43128(null, x, y, z, class_3417.field_15119, class_3419.field_15248, 0.8f, 0.9f + world.field_9229.method_43057() * 0.1f);
    }

    private class_2338 findStandable(class_3218 world, class_2338 pos, int vRange) {
        class_2338.class_2339 mutable = pos.method_25503();
        for (int dy = 0; dy <= vRange; dy++) {
            if (isStandable(world, mutable.method_10103(pos.method_10263(), pos.method_10264() + dy, pos.method_10260()))) return mutable.method_10062();
            if (isStandable(world, mutable.method_10103(pos.method_10263(), pos.method_10264() - dy, pos.method_10260()))) return mutable.method_10062();
        }
        return null;
    }

    private boolean isStandable(class_3218 world, class_2338 pos) {
        class_2338 below = pos.method_10074();
        class_2680 belowState = world.method_8320(below);
        boolean solidBelow = !belowState.method_26220(world, below).method_1110();
        boolean airFeet = world.method_22347(pos);
        boolean airHead = world.method_22347(pos.method_10084());
        return solidBelow && airFeet && airHead;
    }
}