/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.item.gear;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.trique.gemforged.effect.GemforgedEffects;
import net.trique.gemforged.item.GemforgedItems;
import org.joml.Vector3f;

public class GlacialCharmItem
extends class_1792 {
    private static final float RADIUS = 8.0f;
    private static final int COOLDOWN_TICKS = 600;
    private static final int USE_DURATION_TICKS = 20;
    private static final int DURATION_GFL = 300;
    private static final int AMP_GFL = 0;
    private static final class_2390 COL_LIGHT = new class_2390(new Vector3f(0.6431373f, 0.9137255f, 0.9843137f), 2.2f);
    private static final class_2390 COL_MID = new class_2390(new Vector3f(0.32941177f, 0.77254903f, 0.94509804f), 2.2f);
    private static final class_2390 COL_DARK = new class_2390(new Vector3f(0.13333334f, 0.47058824f, 0.73333335f), 2.2f);

    public GlacialCharmItem(class_1792.class_1793 settings) {
        super(settings.method_7895(250));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        user.method_6019(hand);
        if (!world.field_9236) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_26980, class_3419.field_15248, 0.7f, 0.4f);
        }
        return class_1271.method_22428((Object)user.method_5998(hand));
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 20;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (!world.field_9236 && user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            class_1799 resource = this.findChargeResource(player);
            boolean creative = player.method_31549().field_7477;
            if (creative || !resource.method_7960()) {
                this.activateGlacial((class_3218)world, player);
                player.method_7259(class_3468.field_15372.method_14956((Object)this));
                if (!creative) {
                    resource.method_7934(1);
                    stack.method_7956(1, (class_1309)player, p -> p.method_20235(class_1304.field_6173));
                    player.method_7357().method_7906((class_1792)this, 600);
                }
            }
        }
        return stack;
    }

    private class_1799 findChargeResource(class_1657 player) {
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 s = player.method_31548().method_5438(i);
            if (!s.method_31574(GemforgedItems.PRISMYTE)) continue;
            return s;
        }
        return class_1799.field_8037;
    }

    private void activateGlacial(class_3218 world, class_1657 player) {
        class_243 center = player.method_19538();
        world.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_15081, class_3419.field_15248, 1.6f, 0.4f);
        this.spawnSnowflakeCoreFractal(world, center);
        this.spawn3DAxisFlakes(world, center);
        this.spawnSphereRings(world, center);
        this.spawnCloud(world, center);
        this.applyGlacialFist(world, player, center);
    }

    private void applyGlacialFist(class_3218 world, class_1657 caster, class_243 c) {
        class_238 box = new class_238(c.field_1352 - 8.0, c.field_1351 - 8.0, c.field_1350 - 8.0, c.field_1352 + 8.0, c.field_1351 + 8.0, c.field_1350 + 8.0);
        List allies = world.method_8390(class_1309.class, box, e -> e.method_5722((class_1297)caster) || e == caster);
        for (class_1309 ally : allies) {
            ally.method_6092(new class_1293(GemforgedEffects.GLACIAL_FIST, 300, 0, true, true));
        }
    }

    private static class_2390 pick(int i) {
        int m = i % 3;
        return m == 0 ? COL_LIGHT : (m == 1 ? COL_MID : COL_DARK);
    }

    private void spawnSnowflakeCoreFractal(class_3218 world, class_243 c) {
        int arms = 8;
        int segments = 12;
        double cx = c.field_1352;
        double cy = c.field_1351 + 0.3;
        double cz = c.field_1350;
        for (int arm = 0; arm < arms; ++arm) {
            double base = (double)arm * (Math.PI * 2 / (double)arms);
            for (int i = 1; i <= segments; ++i) {
                double t = (double)i / (double)segments;
                double dist = t * 6.8;
                class_2390 col = GlacialCharmItem.pick(i);
                double sx = cx + Math.cos(base) * dist;
                double sz = cz + Math.sin(base) * dist;
                world.method_14199((class_2394)col, sx, cy, sz, 2, 0.01, 0.01, 0.01, 0.006);
                double branch = base + (i % 2 == 0 ? 0.39269908169872414 : -0.39269908169872414);
                double bd = dist * 0.35;
                double bx = sx + Math.cos(branch) * bd;
                double bz = sz + Math.sin(branch) * bd;
                world.method_14199((class_2394)col, bx, cy, bz, 1, 0.008, 0.008, 0.008, 0.004);
            }
        }
    }

    private void spawn3DAxisFlakes(class_3218 world, class_243 c) {
        int samples = 16;
        double cx = c.field_1352;
        double cy = c.field_1351 + 0.3;
        double cz = c.field_1350;
        for (int i = 1; i <= samples; ++i) {
            double t = (double)i / (double)samples;
            double d = t * 8.0;
            class_2390 col = GlacialCharmItem.pick(i);
            world.method_14199((class_2394)col, cx + d, cy, cz, 1, 0.01, 0.01, 0.01, 0.006);
            world.method_14199((class_2394)col, cx - d, cy, cz, 1, 0.01, 0.01, 0.01, 0.006);
            world.method_14199((class_2394)col, cx, cy + d, cz, 1, 0.01, 0.01, 0.01, 0.006);
            world.method_14199((class_2394)col, cx, cy - d, cz, 1, 0.01, 0.01, 0.01, 0.006);
            world.method_14199((class_2394)col, cx, cy, cz + d, 1, 0.01, 0.01, 0.01, 0.006);
            world.method_14199((class_2394)col, cx, cy, cz - d, 1, 0.01, 0.01, 0.01, 0.006);
        }
    }

    private void spawnSphereRings(class_3218 world, class_243 c) {
        int rings = 2;
        int perRing = 64;
        double cx = c.field_1352;
        double cy = c.field_1351 + 0.3;
        double cz = c.field_1350;
        for (int r = 1; r <= rings; ++r) {
            double rr = 8.0f / (float)rings * (float)r;
            for (int i = 0; i < perRing; ++i) {
                double a = Math.PI * 2 * (double)i / (double)perRing;
                class_2390 col = GlacialCharmItem.pick(i);
                double x1 = cx + Math.cos(a) * rr;
                double z1 = cz + Math.sin(a) * rr;
                world.method_14199((class_2394)col, x1, cy, z1, 2, 0.02, 0.02, 0.02, 0.007);
            }
        }
    }

    private void spawnCloud(class_3218 world, class_243 c) {
        class_1295 cloud = new class_1295((class_1937)world, c.field_1352, c.field_1351 + 0.1, c.field_1350);
        cloud.method_5608((class_2394)COL_MID);
        cloud.method_5603(8.0f);
        cloud.method_5604(30);
        cloud.method_5596(-0.15f);
        cloud.method_5875(true);
        world.method_8649((class_1297)cloud);
    }
}

