/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.item.gear;

import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import net.trique.gemforged.item.GemforgedItems;
import org.joml.Vector3f;

public class SandburstStaffItem
extends class_1792 {
    private static final float MAX_RADIUS = 10.0f;
    private static final float BASE_KNOCKBACK = 12.0f;
    private static final double VERTICAL_BOOST = 1.0;
    private static final int COOLDOWN_TICKS = 400;
    private static final float MAGIC_DAMAGE = 6.0f;
    private static final int USE_DURATION_TICKS = 20;
    private static final Vector3f YELLOW = new Vector3f(0.9176f, 0.7765f, 0.1569f);
    private static final Vector3f SAND = new Vector3f(0.7922f, 0.5843f, 0.102f);
    private static final float YELLOW_SCALE = 1.6f;
    private static final float SAND_SCALE = 2.0f;
    private static final int WAVE_COUNT = 3;
    private static final int WAVE_FRAMES = 16;
    private static final int WAVE_FRAME_STEP = 2;
    private static final int WAVE_GAP_TICKS = 4;
    private static final float MIN_RENDER_RADIUS = 0.8f;
    private static final float RINGS_HEIGHT = 2.0f;

    public SandburstStaffItem(FabricItemSettings settings) {
        super((class_1792.class_1793)settings.maxDamage(250));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        user.method_6019(hand);
        if (!world.field_9236) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_26980, class_3419.field_15248, 0.75f, 1.25f);
        }
        return class_1271.method_22428((Object)user.method_5998(hand));
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 20;
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (world.field_9236) {
            return;
        }
        int elapsed = this.method_7881(stack) - remainingUseTicks;
        if (elapsed == 1) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_15119, class_3419.field_15248, 0.7f, 1.05f);
        }
        if (elapsed % 5 == 0) {
            float pitch = 0.9f + (float)elapsed / 20.0f * 0.5f;
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_43154, class_3419.field_15248, 0.35f, pitch);
        }
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (!world.field_9236 && user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            boolean creative = player.method_31549().field_7477;
            class_1799 chargeResource = this.findChargeResource(player);
            if (creative || !chargeResource.method_7960()) {
                this.triggerBurst((class_3218)world, player);
                if (!creative) {
                    chargeResource.method_7934(1);
                    player.method_7357().method_7906((class_1792)this, 400);
                    stack.method_7956(1, (class_1309)player, p -> p.method_20235(class_1304.field_6173));
                }
            }
        }
        return stack;
    }

    private class_1799 findChargeResource(class_1657 player) {
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 s = player.method_31548().method_5438(i);
            if (!s.method_31574(GemforgedItems.SOLARIUM)) continue;
            return s;
        }
        return class_1799.field_8037;
    }

    private void triggerBurst(class_3218 world, class_1657 player) {
        class_243 origin = player.method_19538().method_1031(0.0, 0.2, 0.0);
        world.method_43128(null, origin.field_1352, origin.field_1351, origin.field_1350, class_3417.field_15152, class_3419.field_15248, 0.6f, 1.55f);
        world.method_43128(null, origin.field_1352, origin.field_1351, origin.field_1350, class_3417.field_15074, class_3419.field_15248, 1.2f, 0.85f);
        this.scheduleWaves(world, origin);
        this.affectEntities(world, player);
    }

    private void scheduleWaves(class_3218 world, class_243 center) {
        MinecraftServer server = world.method_8503();
        int start = server.method_3780();
        for (int w = 0; w < 3; ++w) {
            int waveStart = start + w * 4;
            for (int f = 0; f <= 16; f += 2) {
                int when = waveStart + f;
                float t = (float)f / 16.0f;
                float eased = (float)Math.pow(t, 0.6);
                float rad = 0.8f + eased * 9.2f;
                float fade = 1.0f - t;
                class_243 cNow = center;
                server.execute(() -> {
                    this.spawnRingWithSpikesColored(world, cNow, rad, 2.0, fade, YELLOW, 1.6f);
                    this.spawnRingWithSpikesColored(world, cNow, rad, 2.0, fade, SAND, 2.0f);
                });
            }
        }
    }

    private void spawnRingWithSpikesColored(class_3218 world, class_243 center, float radius, double height, float fade, Vector3f color, float scale) {
        double pz;
        double px;
        double a;
        if (radius <= 0.8f) {
            return;
        }
        double cx = center.field_1352;
        double cy = center.field_1351;
        double cz = center.field_1350;
        float r01 = Math.min(1.0f, radius / 10.0f);
        float density = 0.25f + (float)Math.pow(r01, 1.6);
        int points = Math.max(12, (int)(radius * 18.0f * density));
        int layers = 8;
        class_2390 dust = new class_2390(color, scale * (0.8f + 0.5f * fade));
        for (int i = 0; i < points; ++i) {
            a = Math.PI * 2 * (double)i / (double)points;
            px = cx + (double)radius * Math.cos(a);
            pz = cz + (double)radius * Math.sin(a);
            double py = cy + height * 0.5;
            world.method_14199((class_2394)dust, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (radius >= 3.5f) {
            for (int k = 0; k < 8; ++k) {
                a = 0.7853981633974483 * (double)k;
                px = cx + (double)radius * Math.cos(a);
                pz = cz + (double)radius * Math.sin(a);
                for (int h = 0; h <= layers; ++h) {
                    double py = cy + (double)h / (double)layers * height;
                    world.method_14199((class_2394)dust, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private void affectEntities(class_3218 world, class_1657 source) {
        class_243 center = source.method_19538();
        class_238 box = new class_238(center.field_1352 - 10.0, center.field_1351 - 1.0, center.field_1350 - 10.0, center.field_1352 + 10.0, center.field_1351 + 2.5, center.field_1350 + 10.0);
        for (class_1297 e : world.method_8335((class_1297)source, box)) {
            if (e == source || !e.method_5810()) continue;
            class_243 diff = e.method_19538().method_1020(center);
            class_243 horizontal = new class_243(diff.field_1352, 0.0, diff.field_1350);
            double dist = horizontal.method_1033();
            if (dist <= 1.0E-4 || dist > 10.0) continue;
            double falloff = Math.max(0.0, 1.0 - dist / 10.0);
            double strength = 12.0 * falloff;
            class_243 push = horizontal.method_1029().method_1021(strength);
            e.method_5762(push.field_1352, 1.0 * falloff, push.field_1350);
            if (!(e instanceof class_1309)) continue;
            class_1309 le = (class_1309)e;
            le.method_5643(world.method_48963().method_48831(), 6.0f);
        }
    }
}

