/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.item.gear;

import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.trique.gemforged.item.GemforgedItems;
import org.joml.Vector3f;

public class VenomfangBladeItem
extends class_1829 {
    private static final int HIT_THRESHOLD = 3;
    private static final int SUPER_THRESHOLD = 10;
    private static final float MAGIC_DAMAGE = 5.0f;
    private static final float WAVE_MAX_RADIUS = 7.0f;
    private static final int WAVE_FRAMES = 16;
    private static final int WAVE_COUNT = 3;
    private static final int WAVE_GAP_TICKS = 6;
    private static final int POISON_DURATION = 300;
    private static final int WITHER_DURATION = 300;
    private static final double KNOCKBACK_STRENGTH = 1.5;
    private static final double KNOCKBACK_VERTICAL = 0.5;
    private static final Vector3f GREEN = new Vector3f(0.1961f, 0.7451f, 0.5529f);
    private static final float GREEN_SCALE = 1.8f;
    private static final Vector3f DARK_GREEN = new Vector3f(0.0706f, 0.2549f, 0.1608f);
    private static final Vector3f WITHER_BLACK = new Vector3f(0.1608f, 0.1608f, 0.1608f);
    private static final float DARK_SCALE = 2.1f;

    public VenomfangBladeItem(class_1792.class_1793 settings) {
        super((class_1832)class_1834.field_8923, 2, -2.0f, settings);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        boolean res = super.method_7873(stack, target, attacker);
        class_1937 world = attacker.method_37908();
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            if (!world.field_9236) {
                int count = stack.method_7948().method_10550("venomfang_hits") + 1;
                int superCount = stack.method_7948().method_10550("venomfang_super") + 1;
                if (count >= 3) {
                    if (this.consumeVenomyte(player)) {
                        this.triggerVenomWaves((class_3218)world, player, target);
                        count = 0;
                    } else {
                        count = 0;
                    }
                }
                if (superCount >= 10) {
                    if (this.consumeVenomyte(player)) {
                        this.triggerWitherBlast((class_3218)world, player, target);
                        superCount = 0;
                    } else {
                        superCount = 0;
                    }
                }
                stack.method_7948().method_10569("venomfang_hits", count);
                stack.method_7948().method_10569("venomfang_super", superCount);
            }
        }
        return res;
    }

    private boolean consumeVenomyte(class_1657 player) {
        if (player.method_31549().field_7477) {
            return true;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 s = player.method_31548().method_5438(i);
            if (!s.method_31574(GemforgedItems.VENOMYTE)) continue;
            s.method_7934(1);
            return true;
        }
        return false;
    }

    private void triggerVenomWaves(class_3218 world, class_1657 attacker, class_1309 source) {
        class_243 center = source.method_19538().method_1031(0.0, 0.05, 0.0);
        world.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_14565, class_3419.field_15248, 0.9f, 0.95f);
        world.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_14978, class_3419.field_15248, 0.9f, 1.25f);
        for (int w = 0; w < 3; ++w) {
            int baseDelay = w * 6;
            world.method_8503().execute(() -> {
                world.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_15095, class_3419.field_15248, 0.75f, 0.8f);
                world.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_15170, class_3419.field_15248, 0.6f, 0.55f);
            });
            for (int f = 0; f <= 16; ++f) {
                float t = (float)f / 16.0f;
                float rad = t * 7.0f;
                float fade = 1.0f - t;
                this.spawnRing(world, center, rad, 2.0, fade, GREEN, 1.8f);
            }
        }
        class_238 box = new class_238(center.field_1352 - 7.0, center.field_1351 - 1.0, center.field_1350 - 7.0, center.field_1352 + 7.0, center.field_1351 + 2.0, center.field_1350 + 7.0);
        for (class_1309 e : world.method_8390(class_1309.class, box, le -> le.method_5805() && le != attacker)) {
            e.method_6092(new class_1293(class_1294.field_5899, 300));
            e.method_5643(world.method_48963().method_48831(), 5.0f);
            class_243 diff = e.method_19538().method_1020(center);
            class_243 push = new class_243(diff.field_1352, 0.0, diff.field_1350).method_1029().method_1021(1.5);
            e.method_5762(push.field_1352, 0.5, push.field_1350);
            e.field_6037 = true;
        }
        world.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_15067, class_3419.field_15248, 0.6f, 1.35f);
    }

    private void triggerWitherBlast(class_3218 world, class_1657 attacker, class_1309 source) {
        class_243 center = source.method_19538().method_1031(0.0, 0.05, 0.0);
        world.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_15163, class_3419.field_15248, 1.2f, 0.9f);
        for (int f = 0; f <= 16; ++f) {
            float t = (float)f / 16.0f;
            float rad = t * 7.0f;
            float fade = 1.0f - t;
            this.spawnRing(world, center, rad, 2.0, fade, DARK_GREEN, 2.1f);
            this.spawnRing(world, center, rad, 2.0, fade, WITHER_BLACK, 2.1f);
            world.method_14199((class_2394)class_2398.field_11251, center.field_1352, center.field_1351, center.field_1350, 8, (double)rad * 0.2, 0.2, (double)rad * 0.2, 0.01);
        }
        class_238 box = new class_238(center.field_1352 - 7.0, center.field_1351 - 1.0, center.field_1350 - 7.0, center.field_1352 + 7.0, center.field_1351 + 2.0, center.field_1350 + 7.0);
        for (class_1309 e : world.method_8390(class_1309.class, box, le -> le.method_5805() && le != attacker)) {
            e.method_6092(new class_1293(class_1294.field_5920, 300));
            e.method_5643(world.method_48963().method_48831(), 10.0f);
        }
        world.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_38068, class_3419.field_15248, 0.6f, 0.8f);
    }

    private void spawnRing(class_3218 world, class_243 center, float radius, double height, float fade, Vector3f color, float scale) {
        double pz;
        double px;
        double a;
        if (radius <= 0.05f) {
            return;
        }
        double cx = center.field_1352;
        double cy = center.field_1351;
        double cz = center.field_1350;
        float r01 = Math.min(1.0f, radius / 7.0f);
        float density = 0.25f + (float)Math.pow(r01, 1.6);
        int points = Math.max(12, (int)(radius * 18.0f * density));
        int layers = 8;
        class_2390 dust = new class_2390(color, scale * (0.8f + 0.5f * fade));
        for (int i = 0; i < points; ++i) {
            a = Math.PI * 2 * (double)i / (double)points;
            px = cx + (double)radius * Math.cos(a);
            pz = cz + (double)radius * Math.sin(a);
            double py = cy + height * 0.5;
            world.method_14199((class_2394)dust, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (radius >= 2.45f) {
            for (int k = 0; k < 8; ++k) {
                a = 0.7853981633974483 * (double)k;
                px = cx + (double)radius * Math.cos(a);
                pz = cz + (double)radius * Math.sin(a);
                for (int h = 0; h <= layers; ++h) {
                    double py = cy + (double)h / (double)layers * height;
                    world.method_14199((class_2394)dust, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

