package net.trique.gemforged;

import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_7877;
import net.minecraft.class_7924;
import net.trique.gemforged.data.*;
import net.trique.gemforged.world.GemforgedConfiguredFeatures;
import net.trique.gemforged.world.GemforgedPlacedFeatures;

public class GemforgedDataGenerator implements DataGeneratorEntrypoint {
    @Override
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();

        pack.addProvider(GemforgedBlockLootTableProvider::new);
        pack.addProvider(GemforgedRecipeProvider::new);
        pack.addProvider(GemforgedModelProvider::new);
        pack.addProvider(GemforgedWorldGenerator::new);
    }

    @Override
    public void buildRegistry(class_7877 registryBuilder) {
        registryBuilder.method_46777(class_7924.field_41239, GemforgedConfiguredFeatures::bootstrap);
        registryBuilder.method_46777(class_7924.field_41245, GemforgedPlacedFeatures::bootstrap);
    }
}