package net.trique.gemforged.item.gear;

import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.trique.gemforged.item.GemforgedItems;
import org.joml.Vector3f;

import java.util.List;

public class GravityHornItem extends class_1792 {
    private static final float RADIUS = 16f;
    private static final int COOLDOWN_TICKS = 20 * 30;
    private static final int USE_DURATION_TICKS = 20;

    private static final class_2390 PURPLE =
            new class_2390(new Vector3f(0.3843f, 0.0784f, 0.4078f), 3.0f);
    private static final class_2390 LILAC =
            new class_2390(new Vector3f(0.8196f, 0.1647f, 0.8588f), 3.0f);

    public GravityHornItem(FabricItemSettings settings) {
        super(settings.method_7895(250));
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        user.method_6019(hand);
        if (!world.field_9236) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(),
                    class_3417.field_15119, class_3419.field_15248, 2.0f, 0.6f);
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(),
                    class_3417.field_43154, class_3419.field_15248, 2.5f, 0.7f);
        }
        return class_1271.method_22428(user.method_5998(hand));
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_39058;
    }

    @Override
    public int method_7881(class_1799 stack) {
        return USE_DURATION_TICKS;
    }

    @Override
    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (!world.field_9236 && user instanceof class_1657 player) {
            boolean creative = player.method_31549().field_7477;
            class_1799 chargeResource = findChargeResource(player);

            if (creative || !chargeResource.method_7960()) {
                triggerBurst((class_3218) world, player);

                if (!creative) {
                    chargeResource.method_7934(1);
                    player.method_7357().method_7906(this, COOLDOWN_TICKS);
                    stack.method_7956(1, player, p -> p.method_20235(class_1304.field_6173));
                }
            }
        }
        return stack;
    }

    private class_1799 findChargeResource(class_1657 player) {
        for (int i = 0; i < player.method_31548().method_5439(); i++) {
            class_1799 s = player.method_31548().method_5438(i);
            if (s.method_31574(GemforgedItems.GRAVITIUM)) return s;
        }
        return class_1799.field_8037;
    }

    private void triggerBurst(class_3218 world, class_1657 player) {
        class_243 c = player.method_19538();

        world.method_43128(null, c.field_1352, c.field_1351, c.field_1350,
                class_3417.field_26980, class_3419.field_15248, 3.0f, 0.5f);
        world.method_43128(null, c.field_1352, c.field_1351, c.field_1350,
                class_3417.field_14703, class_3419.field_15248, 3.0f, 0.8f);
        world.method_43128(null, c.field_1352, c.field_1351, c.field_1350,
                class_3417.field_14981, class_3419.field_15248, 2.5f, 0.9f);

        spawnRing(world, c.method_1031(0, 0.3, 0), RADIUS, 1200, PURPLE, 1.0f);
        spawnRing(world, c.method_1031(0, 0.35, 0), RADIUS, 1200, LILAC, 1.0f);
        spawnStar(world, c.method_1031(0, 0.5, 0), 12.0, 5, PURPLE);
        spawnStar(world, c.method_1031(0, 0.5, 0), 12.0, 5, LILAC);

        class_238 box = new class_238(
                c.field_1352 - RADIUS, c.field_1351 - RADIUS, c.field_1350 - RADIUS,
                c.field_1352 + RADIUS, c.field_1351 + RADIUS, c.field_1350 + RADIUS
        );

        List<class_1309> targets = world.method_8390(class_1309.class, box,
                e -> e.method_5805() && e != player);

        for (class_1309 e : targets) {
            e.method_6092(new class_1293(class_1294.field_5902, 20 * 5, 2, true, true));
        }
    }

    private void spawnRing(class_3218 world, class_243 center, float radius, int points, class_2390 dust, float heightSpread) {
        double cx = center.field_1352, cy = center.field_1351, cz = center.field_1350;
        for (int i = 0; i < points; i++) {
            double a = (Math.PI * 2 * i) / points;
            double px = cx + radius * Math.cos(a);
            double pz = cz + radius * Math.sin(a);
            double py = cy + (world.field_9229.method_43058() - 0.5) * heightSpread * 2;
            world.method_14199(dust, px, py, pz, 2, 0.04, 0.04, 0.04, 0.01);
        }
    }

    private void spawnStar(class_3218 world, class_243 center, double radius, int points, class_2390 dust) {
        double cx = center.field_1352, cy = center.field_1351, cz = center.field_1350;
        double[] xs = new double[points];
        double[] zs = new double[points];

        for (int i = 0; i < points; i++) {
            double angle = 2 * Math.PI * i / points - Math.PI / 2;
            xs[i] = cx + radius * Math.cos(angle);
            zs[i] = cz + radius * Math.sin(angle);
        }

        for (int i = 0; i < points; i++) {
            int j = (i + 2) % points;
            spawnLine(world, cy, xs[i], zs[i], xs[j], zs[j], dust);
        }
    }

    private void spawnLine(class_3218 world, double cy, double x1, double z1, double x2, double z2, class_2390 dust) {
        int steps = 100;
        for (int i = 0; i <= steps; i++) {
            double t = i / (double) steps;
            double px = x1 + (x2 - x1) * t;
            double pz = z1 + (z2 - z1) * t;
            world.method_14199(dust, px, cy, pz, 2, 0.05, 0.05, 0.05, 0.01);
        }
    }
}
