package net.trique.gemforged.item.gear;

import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import net.trique.gemforged.item.GemforgedItems;
import org.joml.Vector3f;

public class SandburstStaffItem extends class_1792 {
    private static final float MAX_RADIUS = 10.0f;
    private static final float BASE_KNOCKBACK = 16.0f;
    private static final double VERTICAL_BOOST = 1.0;
    private static final int COOLDOWN_TICKS = 20 * 30;
    private static final float MAGIC_DAMAGE = 5.0f;
    private static final int USE_DURATION_TICKS = 20;
    private static final Vector3f YELLOW = new Vector3f(0.9176f, 0.7765f, 0.1569f);
    private static final Vector3f SAND = new Vector3f(0.7922f, 0.5843f, 0.1020f);
    private static final float YELLOW_SCALE = 1.6f;
    private static final float SAND_SCALE = 2.0f;
    private static final int WAVE_COUNT = 3;
    private static final int WAVE_FRAMES = 16;
    private static final int WAVE_FRAME_STEP = 2;
    private static final int WAVE_GAP_TICKS = 4;
    private static final float MIN_RENDER_RADIUS = 0.8f;
    private static final float RINGS_HEIGHT = 2.0f;

    public SandburstStaffItem(FabricItemSettings settings) {
        super(settings.method_7895(250));
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        user.method_6019(hand);
        if (!world.field_9236) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(),
                    class_3417.field_26980, class_3419.field_15248, 0.75f, 1.25f);
        }
        return class_1271.method_22428(user.method_5998(hand));
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    @Override
    public int method_7881(class_1799 stack) {
        return USE_DURATION_TICKS;
    }

    @Override
    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (world.field_9236) return;
        int elapsed = method_7881(stack) - remainingUseTicks;
        if (elapsed == 1) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(),
                    class_3417.field_15119, class_3419.field_15248, 0.7F, 1.05F);
        }
        if (elapsed % 5 == 0) {
            float pitch = 0.9f + (elapsed / (float) USE_DURATION_TICKS) * 0.5f;
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(),
                    class_3417.field_43154, class_3419.field_15248, 0.35F, pitch);
        }
    }

    @Override
    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (!world.field_9236 && user instanceof class_1657 player) {
            boolean creative = player.method_31549().field_7477;
            class_1799 chargeResource = findChargeResource(player);

            if (creative || !chargeResource.method_7960()) {
                triggerBurst((class_3218) world, player);
                if (!creative) {
                    chargeResource.method_7934(1);
                    player.method_7357().method_7906(this, COOLDOWN_TICKS);
                    stack.method_7956(1, player, p -> p.method_20235(class_1304.field_6173));
                }
            }
        }
        return stack;
    }

    private class_1799 findChargeResource(class_1657 player) {
        for (int i = 0; i < player.method_31548().method_5439(); i++) {
            class_1799 s = player.method_31548().method_5438(i);
            if (s.method_31574(GemforgedItems.SOLARIUM)) return s;
        }
        return class_1799.field_8037;
    }

    private void triggerBurst(class_3218 world, class_1657 player) {
        class_243 origin = player.method_19538().method_1031(0, 0.2, 0);
        world.method_43128(null, origin.field_1352, origin.field_1351, origin.field_1350, class_3417.field_15152, class_3419.field_15248, 0.6f, 1.55f);
        world.method_43128(null, origin.field_1352, origin.field_1351, origin.field_1350, class_3417.field_15074, class_3419.field_15248, 1.2f, 0.85f);
        scheduleWaves(world, origin);
        affectEntities(world, player);
    }

    private void scheduleWaves(class_3218 world, class_243 center) {
        MinecraftServer server = world.method_8503();
        final int start = server.method_3780();
        for (int w = 0; w < WAVE_COUNT; w++) {
            final int waveStart = start + w * WAVE_GAP_TICKS;
            for (int f = 0; f <= WAVE_FRAMES; f += WAVE_FRAME_STEP) {
                final int when = waveStart + f;
                final float t = f / (float) WAVE_FRAMES;
                final float eased = (float) Math.pow(t, 0.6);
                final float rad = MIN_RENDER_RADIUS + eased * (MAX_RADIUS - MIN_RENDER_RADIUS);
                final float fade = 1.0f - t;
                final class_243 cNow = center;

                server.execute(() -> {
                    spawnRingWithSpikesColored(world, cNow, rad, RINGS_HEIGHT, fade, YELLOW, YELLOW_SCALE);
                    spawnRingWithSpikesColored(world, cNow, rad, RINGS_HEIGHT, fade, SAND, SAND_SCALE);
                });
            }
        }
    }

    private void spawnRingWithSpikesColored(class_3218 world, class_243 center, float radius, double height, float fade,
                                            Vector3f color, float scale) {
        if (radius <= MIN_RENDER_RADIUS) return;

        final double cx = center.field_1352, cy = center.field_1351, cz = center.field_1350;
        float r01 = Math.min(1f, radius / MAX_RADIUS);
        float density = 0.25f + (float) Math.pow(r01, 1.6);
        int points = Math.max(12, (int) (radius * 18 * density));
        int layers = 8;

        class_2390 dust = new class_2390(color, scale * (0.8f + 0.5f * fade));

        for (int i = 0; i < points; i++) {
            double a = (Math.PI * 2 * i) / points;
            double px = cx + radius * Math.cos(a);
            double pz = cz + radius * Math.sin(a);
            double py = cy + height * 0.5;
            world.method_14199(dust, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
        }

        if (radius >= MAX_RADIUS * 0.35f) {
            for (int k = 0; k < 8; k++) {
                double a = (Math.PI / 4.0) * k;
                double px = cx + radius * Math.cos(a);
                double pz = cz + radius * Math.sin(a);
                for (int h = 0; h <= layers; h++) {
                    double py = cy + (h / (double) layers) * height;
                    world.method_14199(dust, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private void affectEntities(class_3218 world, class_1657 source) {
        class_243 center = source.method_19538();
        class_238 box = new class_238(
                center.field_1352 - MAX_RADIUS, center.field_1351 - 1.0, center.field_1350 - MAX_RADIUS,
                center.field_1352 + MAX_RADIUS, center.field_1351 + 2.5, center.field_1350 + MAX_RADIUS
        );
        for (class_1297 e : world.method_8335(source, box)) {
            if (e == source || !e.method_5810()) continue;
            class_243 diff = e.method_19538().method_1020(center);
            class_243 horizontal = new class_243(diff.field_1352, 0.0, diff.field_1350);
            double dist = horizontal.method_1033();
            if (dist <= 0.0001 || dist > MAX_RADIUS) continue;
            double falloff = Math.max(0.0, 1.0 - (dist / MAX_RADIUS));
            double strength = BASE_KNOCKBACK * falloff;
            class_243 push = horizontal.method_1029().method_1021(strength);
            e.method_5762(push.field_1352, VERTICAL_BOOST * falloff, push.field_1350);
            if (e instanceof class_1309 le) {
                le.method_5643(world.method_48963().method_48831(), MAGIC_DAMAGE);
            }
        }
    }
}
