/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.entity;

import java.awt.Color;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1321;
import net.minecraft.class_1439;
import net.minecraft.class_1473;
import net.minecraft.class_1496;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3856;
import net.trique.gemforged.entity.GemforgedEntities;
import net.trique.gemforged.item.GemforgedItems;
import org.joml.Vector3f;

public class VerdantTotemEntity
extends class_1297
implements class_3856 {
    private int life;
    private class_1799 storedItem = class_1799.field_8037;
    private class_1657 owner;
    private UUID ownerId;
    private double originX;
    private double originZ;
    private double targetY;
    private double angle;

    public VerdantTotemEntity(class_1299<? extends VerdantTotemEntity> type, class_1937 world) {
        super(type, world);
        this.method_5875(true);
    }

    public VerdantTotemEntity(class_1937 world, double x, double y, double z, class_1657 owner) {
        this(GemforgedEntities.VERDANT_TOTEM, world);
        this.method_23327(x, y, z);
        this.owner = owner;
        this.ownerId = owner.method_5667();
    }

    public void method_5773() {
        class_3218 serverWorld;
        class_1297 e;
        class_1937 class_19372;
        super.method_5773();
        ++this.life;
        if (this.life == 1) {
            this.originX = this.method_23317();
            this.originZ = this.method_23321();
            this.targetY = this.method_23318() + 4.0;
            if (!this.method_37908().field_9236) {
                this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15119, class_3419.field_15248, 1.0f, 0.7f);
            }
        }
        if (this.owner == null && this.ownerId != null && (class_19372 = this.method_37908()) instanceof class_3218 && (e = (serverWorld = (class_3218)class_19372).method_14190(this.ownerId)) instanceof class_1657) {
            class_1657 p;
            this.owner = p = (class_1657)e;
        }
        double dy = this.method_23318() < this.targetY ? 0.05 : 0.0;
        double speed = 0.35;
        this.angle += speed;
        double radius = 0.8;
        double desiredX = this.originX + Math.cos(this.angle) * radius;
        double desiredZ = this.originZ + Math.sin(this.angle) * radius;
        double dx = (desiredX - this.method_23317()) * 0.4;
        double dz = (desiredZ - this.method_23321()) * 0.4;
        this.method_18800(dx, dy, dz);
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_36456(this.method_36454() + 8.0f);
        class_1937 class_19373 = this.method_37908();
        if (class_19373 instanceof class_3218) {
            class_3218 server = (class_3218)class_19373;
            if (this.life % 4 == 0) {
                server.method_14199((class_2394)new class_2390(new Vector3f(0.2f, 0.9f, 0.2f), 1.0f), this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 4, 0.35, 0.35, 0.35, 0.01);
            }
            for (int i = 0; i < 6; ++i) {
                double a = Math.PI * 2 * (double)i / 6.0;
                double px = this.method_23317() + Math.cos(a) * 1.5;
                double pz = this.method_23321() + Math.sin(a) * 1.5;
                double py = this.method_23318() + 0.1 * Math.sin((double)(this.life + i * 5) * 0.2);
                server.method_14199((class_2394)class_2398.field_17741, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (this.life % 20 == 0) {
                this.applyRegen();
            }
        }
        if (this.life == 200 && !this.method_37908().field_9236) {
            this.explode();
        }
        if (this.life > 220 && !this.method_37908().field_9236) {
            this.dropItemAndRemove();
        }
    }

    private void applyRegen() {
        class_238 area = this.method_5829().method_1014(12.0);
        List allies = this.method_37908().method_8390(class_1309.class, area, this::isAlly);
        for (class_1309 e : allies) {
            e.method_6092(new class_1293(class_1294.field_5924, 60, 1, false, true, true));
        }
    }

    private void explode() {
        int i;
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)class_19372;
        for (i = 0; i < 4; ++i) {
            float pitch = 0.7f + (float)i * 0.1f;
            server.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_43154, class_3419.field_15248, 4.0f, pitch);
            server.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_26942, class_3419.field_15248, 4.0f, pitch);
            server.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14931, class_3419.field_15248, 4.0f, pitch);
        }
        server.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14703, class_3419.field_15248, 4.0f, 1.0f);
        for (i = 0; i < 120; ++i) {
            server.method_14199((class_2394)new class_2390(new Vector3f(0.4f, 1.0f, 0.4f), 1.5f), this.method_23317(), this.method_23318(), this.method_23321(), 1, this.field_5974.method_43059(), this.field_5974.method_43059(), this.field_5974.method_43059(), 0.04);
        }
        int[] colors = new int[]{3047689, 4896266, 7590410, 10347788, 14151429};
        int rings = 5;
        int pointsPerRing = 64;
        double maxRadius = 8.0;
        for (int ring = 0; ring < rings; ++ring) {
            double r = maxRadius / (double)rings * (double)(ring + 1);
            Color c = new Color(colors[ring]);
            Vector3f colorVec = new Vector3f((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
            for (int p = 0; p < pointsPerRing; ++p) {
                double a = Math.PI * 2 * (double)p / (double)pointsPerRing;
                double px = this.method_23317() + Math.cos(a) * r;
                double pz = this.method_23321() + Math.sin(a) * r;
                double py = this.method_23318();
                this.spawnColoredSet(server, px, py, pz, colorVec);
                double vy = this.method_23318() + Math.sin(a) * r;
                double vz = this.method_23321() + Math.cos(a) * r;
                double vx = this.method_23317();
                this.spawnColoredSet(server, vx, vy, vz, colorVec);
                double xx = this.method_23317() + Math.cos(a) * r;
                double yy = this.method_23318() + Math.sin(a) * r;
                double zz = this.method_23321();
                this.spawnColoredSet(server, xx, yy, zz, colorVec);
            }
        }
        class_238 area = this.method_5829().method_1014(12.0);
        List allies = this.method_37908().method_8390(class_1309.class, area, this::isAlly);
        for (class_1309 e : allies) {
            e.method_6092(new class_1293(class_1294.field_5915, 1, 4, false, true, true));
            e.method_6092(new class_1293(class_1294.field_5924, 100, 1, false, true, true));
        }
    }

    private void spawnColoredSet(class_3218 server, double x, double y, double z, Vector3f color) {
        server.method_14199((class_2394)new class_2390(color, 1.3f), x, y, z, 10, 0.0, 0.0, 0.0, 0.015);
        server.method_14199((class_2394)class_2398.field_17741, x, y, z, 8, 0.0, 0.0, 0.0, 0.015);
    }

    private void dropItemAndRemove() {
        if (!this.storedItem.method_7960()) {
            class_1799 drop = this.storedItem.method_7972();
            drop.method_7939(1);
            int newDamage = drop.method_7919() + 1;
            if (newDamage < drop.method_7936()) {
                drop.method_7974(newDamage);
                this.method_37908().method_8649((class_1297)new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), drop));
            }
        }
        this.method_31472();
    }

    private boolean isAlly(class_1309 entity) {
        if (entity == this.owner) {
            return true;
        }
        if (this.owner != null && this.owner.method_5722((class_1297)entity)) {
            return true;
        }
        if (entity instanceof class_1321) {
            class_1321 t = (class_1321)entity;
            if (this.owner != null && t.method_35057() == this.owner) {
                return true;
            }
        }
        if (entity instanceof class_1496) {
            class_1496 h = (class_1496)entity;
            if (this.owner != null && h.method_6727() && this.owner.method_5667().equals(h.method_6139())) {
                return true;
            }
        }
        return entity instanceof class_1439 || entity instanceof class_1473;
    }

    protected void method_5693() {
    }

    protected void method_5749(class_2487 nbt) {
        if (nbt.method_10545("Item")) {
            this.storedItem = class_1799.method_7915((class_2487)nbt.method_10562("Item"));
        }
        if (nbt.method_25928("Owner")) {
            this.ownerId = nbt.method_25926("Owner");
        }
        this.originX = nbt.method_10574("OX");
        this.originZ = nbt.method_10574("OZ");
        this.targetY = nbt.method_10574("TY");
        this.angle = nbt.method_10574("Ang");
        this.life = nbt.method_10550("Life");
    }

    protected void method_5652(class_2487 nbt) {
        if (!this.storedItem.method_7960()) {
            nbt.method_10566("Item", (class_2520)this.storedItem.method_7953(new class_2487()));
        }
        if (this.ownerId != null) {
            nbt.method_25927("Owner", this.ownerId);
        }
        nbt.method_10549("OX", this.originX);
        nbt.method_10549("OZ", this.originZ);
        nbt.method_10549("TY", this.targetY);
        nbt.method_10549("Ang", this.angle);
        nbt.method_10569("Life", this.life);
    }

    public class_1799 method_7495() {
        return this.storedItem.method_7960() ? new class_1799((class_1935)GemforgedItems.VERDANT_TOTEM) : this.storedItem;
    }

    public void setItem(class_1799 stack) {
        this.storedItem = stack;
    }

    public void setOwner(class_1657 player) {
        this.owner = player;
        this.ownerId = player == null ? null : player.method_5667();
    }
}

