/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.item.gear;

import java.util.List;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import net.trique.gemforged.effect.GemforgedEffects;
import net.trique.gemforged.item.GemforgedItems;
import org.joml.Vector3f;

public class BattleCharmItem
extends class_1792 {
    private static final float PARTICLE_DENSITY_SCALE = 1.0f;
    private static final float DUST_SIZE_SCALE = 2.0f;
    private static final float RADIUS = 8.0f;
    private static final int COOLDOWN_TICKS = 1800;
    private static final int USE_DURATION_TICKS = 20;
    private static final int DURATION_RAGE = 600;
    private static final int AMP_RAGE = 0;
    private static final int FRAME_STEP = 1;
    private static final int FRAMES = 8;
    private static final float WAVE_START = 6.4f;
    private static final float WAVE_END = 24.0f;
    private static final int VERTICAL_COLUMNS = 12;
    private static final float COLUMN_HEIGHT = 3.5f;
    private static final class_2390 MAIN = new class_2390(new Vector3f(0.8431f, 0.1961f, 0.3686f), 4.0f);
    private static final class_2390 GLOW = new class_2390(new Vector3f(0.9725f, 0.4471f, 0.6823f), 4.8f);
    private static final class_2390 DARK = new class_2390(new Vector3f(0.4667f, 0.102f, 0.1608f), 3.2f);

    public BattleCharmItem(FabricItemSettings settings) {
        super((class_1792.class_1793)settings.maxDamage(250));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        user.method_6019(hand);
        if (!world.field_9236) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_26980, class_3419.field_15248, 0.75f, 1.25f);
        }
        return class_1271.method_22428((Object)user.method_5998(hand));
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (world.field_9236) {
            return;
        }
        int elapsed = this.method_7881(stack) - remainingUseTicks;
        if (elapsed == 1) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_15119, class_3419.field_15248, 0.7f, 1.05f);
        }
        if (elapsed % 5 == 0) {
            float pitch = 0.9f + (float)elapsed / 20.0f * 0.5f;
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_43154, class_3419.field_15248, 0.35f, pitch);
        }
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 20;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (!world.field_9236 && user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            boolean creative = player.method_31549().field_7477;
            class_1799 chargeResource = this.findChargeResource(player);
            if (creative || !chargeResource.method_7960()) {
                this.triggerBurst((class_3218)world, player);
                if (!creative) {
                    chargeResource.method_7934(1);
                    player.method_7357().method_7906((class_1792)this, 1800);
                    stack.method_7956(1, (class_1309)player, p -> p.method_20235(class_1304.field_6173));
                }
            }
        }
        return stack;
    }

    private class_1799 findChargeResource(class_1657 player) {
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 s = player.method_31548().method_5438(i);
            if (!s.method_31574(GemforgedItems.BLOODSTONE)) continue;
            return s;
        }
        return class_1799.field_8037;
    }

    private void triggerBurst(class_3218 world, class_1657 player) {
        class_243 c = player.method_19538();
        world.method_43128(null, c.field_1352, c.field_1351, c.field_1350, class_3417.field_15119, class_3419.field_15248, 2.0f, 0.1f);
        world.method_43128(null, c.field_1352, c.field_1351, c.field_1350, class_3417.field_43154, class_3419.field_15248, 2.0f, 0.1f);
        this.spawnRing(world, c.method_1031(0.0, 0.2, 0.0), 8.0f, BattleCharmItem.scaledCount(105), MAIN);
        this.spawnRing(world, c.method_1031(0.0, 0.5, 0.0), 6.0f, BattleCharmItem.scaledCount(85), GLOW);
        this.spawnLingeringCloud(world, c, 3.0f, 8.8f);
        this.scheduleWave(world, c);
        class_238 box = new class_238(c.field_1352 - 10.0, c.field_1351 - 4.0, c.field_1350 - 10.0, c.field_1352 + 10.0, c.field_1351 + 4.0, c.field_1350 + 10.0);
        List targets = world.method_8390(class_1309.class, box, e -> e.method_5805() && (e == player || e.method_5722((class_1297)player)));
        for (class_1309 e2 : targets) {
            e2.method_6092(new class_1293(GemforgedEffects.RAGE, 600, 0, true, true));
        }
    }

    private void scheduleWave(class_3218 world, class_243 center) {
        MinecraftServer server = world.method_8503();
        int start = server.method_3780();
        for (int f = 0; f <= 8; ++f) {
            float t = (float)f / 8.0f;
            float tt = BattleCharmItem.easeOutCubic(t);
            float radius = BattleCharmItem.lerp(6.4f, 24.0f, tt);
            double yLift = 0.05 * (double)f;
            server.execute(() -> {
                this.spawnRing(world, center.method_1031(0.0, yLift, 0.0), radius, BattleCharmItem.scaledCount(95), MAIN);
                this.spawnRing(world, center.method_1031(0.0, yLift + 0.12, 0.0), radius * 0.92f, BattleCharmItem.scaledCount(80), GLOW);
                this.spawnVerticalColumnsFrame(world, center, radius, 3.5f, 12);
            });
        }
    }

    private void spawnVerticalColumnsFrame(class_3218 world, class_243 center, float radius, float height, int columns) {
        double cx = center.field_1352;
        double cy = center.field_1351;
        double cz = center.field_1350;
        double stepAngle = Math.PI * 2 / (double)columns;
        for (int i = 0; i < columns; ++i) {
            double a = (double)i * stepAngle;
            double x = cx + (double)radius * Math.cos(a);
            double z = cz + (double)radius * Math.sin(a);
            int samples = 8;
            for (int j = 0; j < samples; ++j) {
                double u = (double)j / (double)(samples - 1);
                double y = cy + 0.2 + u * (double)height;
                if ((j & 1) == 0) {
                    world.method_14199((class_2394)DARK, x, y, z, 1, 0.02, 0.06, 0.02, 0.0);
                } else {
                    world.method_14199((class_2394)GLOW, x, y, z, 1, 0.02, 0.06, 0.02, 0.0);
                }
                if (j != samples - 1) continue;
                world.method_14199((class_2394)class_2398.field_11215, x, y + 0.02, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void spawnRing(class_3218 world, class_243 center, float radius, int points, class_2390 dust) {
        double cx = center.field_1352;
        double cy = center.field_1351;
        double cz = center.field_1350;
        for (int i = 0; i < points; ++i) {
            double a = Math.PI * 2 * (double)i / (double)points;
            double px = cx + (double)radius * Math.cos(a);
            double pz = cz + (double)radius * Math.sin(a);
            world.method_14199((class_2394)dust, px, cy, pz, 1, 0.04, 0.04, 0.04, 0.0);
        }
    }

    private void spawnLingeringCloud(class_3218 world, class_243 center, float seconds, float startRadius) {
        int duration = (int)(seconds * 20.0f);
        class_1295 cloud = new class_1295((class_1937)world, center.field_1352, center.field_1351 + 0.1, center.field_1350);
        cloud.method_5608((class_2394)DARK);
        cloud.method_5604(duration);
        cloud.method_5603(startRadius);
        cloud.method_5596(-(startRadius * 0.6f) / (float)duration);
        cloud.method_5595(0);
        cloud.method_5875(true);
        world.method_8649((class_1297)cloud);
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private static float easeOutCubic(float x) {
        float inv = 1.0f - x;
        return 1.0f - inv * inv * inv;
    }

    private static int scaledCount(int base) {
        return Math.max(1, Math.round((float)base * 1.0f));
    }
}

