/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.trique.gemforged.effect.GemforgedEffects;

public class RageOverlay {
    private static final float BASE_ALPHA = 0.32f;
    private static final float PULSE_ALPHA = 0.16f;
    private static final int PERIOD_TICKS = 30;
    private static final int RED_RGB = 0xFF0000;

    @SubscribeEvent
    public void onOverlay(RenderGuiLayerEvent.Post event) {
        if (!event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR)) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (!mc.options.getCameraType().isFirstPerson()) {
            return;
        }
        Holder.Reference rage = player.level().registryAccess().lookupOrThrow(Registries.MOB_EFFECT).getOrThrow(GemforgedEffects.RAGE_KEY);
        MobEffectInstance eff = player.getEffect((Holder)rage);
        if (eff == null) {
            return;
        }
        long gt = player.level().getGameTime();
        float phase = (float)(gt % 30L) / 30.0f;
        float alpha = 0.32f + 0.16f * Mth.sin((float)(phase * ((float)Math.PI * 2)));
        alpha = Mth.clamp((float)alpha, (float)0.0f, (float)1.0f);
        GuiGraphics gg = event.getGuiGraphics();
        int w = mc.getWindow().getGuiScaledWidth();
        int h = mc.getWindow().getGuiScaledHeight();
        int a = Mth.clamp((int)Math.round(alpha * 255.0f), (int)0, (int)255);
        int color = a << 24 | 0xFF0000;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        gg.fill(0, 0, w, h, color);
        RenderSystem.disableBlend();
    }
}

