/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.data;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.trique.gemforged.data.GemforgedBlockLootTableProvider;
import net.trique.gemforged.data.GemforgedBlockStateProvider;
import net.trique.gemforged.data.GemforgedDatapackProvider;
import net.trique.gemforged.data.GemforgedItemModelProvider;
import net.trique.gemforged.data.GemforgedRecipeProvider;

@EventBusSubscriber(modid="gemforged")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new GemforgedDatapackProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(GemforgedBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new GemforgedRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new GemforgedItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new GemforgedBlockStateProvider(packOutput, existingFileHelper));
    }
}

