/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.data;

import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.trique.gemforged.block.GemforgedBlocks;
import net.trique.gemforged.item.GemforgedItems;

public class GemforgedBlockLootTableProvider
extends BlockLootSubProvider {
    public GemforgedBlockLootTableProvider(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected void generate() {
        this.dropSelf((Block)GemforgedBlocks.NYXITE_BLOCK.get());
        this.dropSelf((Block)GemforgedBlocks.BLOODSTONE_BLOCK.get());
        this.dropSelf((Block)GemforgedBlocks.SOLARIUM_BLOCK.get());
        this.dropSelf((Block)GemforgedBlocks.VENOMYTE_BLOCK.get());
        this.dropSelf((Block)GemforgedBlocks.PHOENIXTONE_BLOCK.get());
        this.dropSelf((Block)GemforgedBlocks.PRISMYTE_BLOCK.get());
        this.dropSelf((Block)GemforgedBlocks.GRAVITIUM_BLOCK.get());
        this.dropSelf((Block)GemforgedBlocks.VERDANTITE_BLOCK.get());
        this.add((Block)GemforgedBlocks.RANDOM_GEM_VEIN.get(), block -> this.createRandomOreDrop((Block)block, (Item)GemforgedItems.NYXITE.get(), (Item)GemforgedItems.BLOODSTONE.get(), (Item)GemforgedItems.SOLARIUM.get(), (Item)GemforgedItems.VENOMYTE.get(), (Item)GemforgedItems.PHOENIXTONE.get(), (Item)GemforgedItems.PRISMYTE.get(), (Item)GemforgedItems.GRAVITIUM.get(), (Item)GemforgedItems.VERDANTITE.get()));
        this.add((Block)GemforgedBlocks.DEEPSLATE_RANDOM_GEM_VEIN.get(), block -> this.createRandomOreDrop((Block)block, (Item)GemforgedItems.NYXITE.get(), (Item)GemforgedItems.BLOODSTONE.get(), (Item)GemforgedItems.SOLARIUM.get(), (Item)GemforgedItems.VENOMYTE.get(), (Item)GemforgedItems.PHOENIXTONE.get(), (Item)GemforgedItems.PRISMYTE.get(), (Item)GemforgedItems.GRAVITIUM.get(), (Item)GemforgedItems.VERDANTITE.get()));
    }

    private LootTable.Builder createRandomOreDrop(Block block, Item ... possibleDrops) {
        LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
        for (Item item : possibleDrops) {
            pool.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()));
        }
        return LootTable.lootTable().withPool(pool);
    }

    protected Iterable<Block> getKnownBlocks() {
        return GemforgedBlocks.BLOCKS.getEntries().stream().map(Holder::value)::iterator;
    }
}

