/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.trique.gemforged.block.GemforgedBlocks;
import net.trique.gemforged.item.GemforgedItems;

public class GemforgedRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public GemforgedRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput out) {
        this.makeStorageRecipes(out, (Item)GemforgedItems.NYXITE.get(), (Block)GemforgedBlocks.NYXITE_BLOCK.get(), "nyxite");
        this.makeStorageRecipes(out, (Item)GemforgedItems.BLOODSTONE.get(), (Block)GemforgedBlocks.BLOODSTONE_BLOCK.get(), "bloodstone");
        this.makeStorageRecipes(out, (Item)GemforgedItems.SOLARIUM.get(), (Block)GemforgedBlocks.SOLARIUM_BLOCK.get(), "solarium");
        this.makeStorageRecipes(out, (Item)GemforgedItems.VENOMYTE.get(), (Block)GemforgedBlocks.VENOMYTE_BLOCK.get(), "venomyte");
        this.makeStorageRecipes(out, (Item)GemforgedItems.PHOENIXTONE.get(), (Block)GemforgedBlocks.PHOENIXTONE_BLOCK.get(), "phoenixtone");
        this.makeStorageRecipes(out, (Item)GemforgedItems.PRISMYTE.get(), (Block)GemforgedBlocks.PRISMYTE_BLOCK.get(), "prismyte");
        this.makeStorageRecipes(out, (Item)GemforgedItems.GRAVITIUM.get(), (Block)GemforgedBlocks.GRAVITIUM_BLOCK.get(), "gravitium");
        this.makeStorageRecipes(out, (Item)GemforgedItems.VERDANTITE.get(), (Block)GemforgedBlocks.VERDANTITE_BLOCK.get(), "verdantite");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)GemforgedItems.SHADOWSTEP_DAGGER.get())).requires((ItemLike)GemforgedItems.DAGGER_TEMPLATE.get()).requires((ItemLike)GemforgedItems.NYXITE.get()).unlockedBy("has_dagger_template", GemforgedRecipeProvider.has((ItemLike)((ItemLike)GemforgedItems.DAGGER_TEMPLATE.get()))).save(out, ResourceLocation.fromNamespaceAndPath((String)"gemforged", (String)"shadowstep_dagger_crafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)GemforgedItems.BATTLE_CHARM.get())).requires((ItemLike)GemforgedItems.CHARM_TEMPLATE.get()).requires((ItemLike)GemforgedItems.BLOODSTONE.get()).unlockedBy("has_charm_template", GemforgedRecipeProvider.has((ItemLike)((ItemLike)GemforgedItems.CHARM_TEMPLATE.get()))).save(out, ResourceLocation.fromNamespaceAndPath((String)"gemforged", (String)"battle_charm_crafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)GemforgedItems.SANDBURST_STAFF.get())).requires((ItemLike)GemforgedItems.STAFF_TEMPLATE.get()).requires((ItemLike)GemforgedItems.SOLARIUM.get()).unlockedBy("has_staff_template", GemforgedRecipeProvider.has((ItemLike)((ItemLike)GemforgedItems.STAFF_TEMPLATE.get()))).save(out, ResourceLocation.fromNamespaceAndPath((String)"gemforged", (String)"sandburst_staff_crafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)GemforgedItems.VENOMFANG_BLADE.get())).requires((ItemLike)GemforgedItems.BLADE_TEMPLATE.get()).requires((ItemLike)GemforgedItems.VENOMYTE.get()).unlockedBy("has_blade_template", GemforgedRecipeProvider.has((ItemLike)((ItemLike)GemforgedItems.BLADE_TEMPLATE.get()))).save(out, ResourceLocation.fromNamespaceAndPath((String)"gemforged", (String)"venomfang_blade_crafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)GemforgedItems.PHOENIX_CHARM.get())).requires((ItemLike)GemforgedItems.CHARM_TEMPLATE.get()).requires((ItemLike)GemforgedItems.PHOENIXTONE.get()).unlockedBy("has_charm_template", GemforgedRecipeProvider.has((ItemLike)((ItemLike)GemforgedItems.CHARM_TEMPLATE.get()))).save(out, ResourceLocation.fromNamespaceAndPath((String)"gemforged", (String)"phoenix_charm_crafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)GemforgedItems.THUNDER_PRISM.get())).requires((ItemLike)GemforgedItems.PRISM_TEMPLATE.get()).requires((ItemLike)GemforgedItems.PRISMYTE.get()).unlockedBy("has_prism_template", GemforgedRecipeProvider.has((ItemLike)((ItemLike)GemforgedItems.PRISM_TEMPLATE.get()))).save(out, ResourceLocation.fromNamespaceAndPath((String)"gemforged", (String)"thunder_prism_crafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)GemforgedItems.GRAVITY_HORN.get())).requires((ItemLike)GemforgedItems.HORN_TEMPLATE.get()).requires((ItemLike)GemforgedItems.GRAVITIUM.get()).unlockedBy("has_horn_template", GemforgedRecipeProvider.has((ItemLike)((ItemLike)GemforgedItems.HORN_TEMPLATE.get()))).save(out, ResourceLocation.fromNamespaceAndPath((String)"gemforged", (String)"gravity_horn_crafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)GemforgedItems.VERDANT_TOTEM.get())).requires((ItemLike)GemforgedItems.TOTEM_TEMPLATE.get()).requires((ItemLike)GemforgedItems.VERDANTITE.get()).unlockedBy("has_totem_template", GemforgedRecipeProvider.has((ItemLike)((ItemLike)GemforgedItems.TOTEM_TEMPLATE.get()))).save(out, ResourceLocation.fromNamespaceAndPath((String)"gemforged", (String)"verdant_totem_crafting"));
    }

    private void makeStorageRecipes(RecipeOutput out, Item gem, Block block, String name) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block).define(Character.valueOf('#'), (ItemLike)gem).pattern("###").pattern("###").pattern("###").unlockedBy("has_" + name, GemforgedRecipeProvider.has((ItemLike)gem)).save(out, ResourceLocation.fromNamespaceAndPath((String)"gemforged", (String)(name + "_block_from_gems")));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)gem, (int)9).requires((ItemLike)block).unlockedBy("has_" + name + "_block", GemforgedRecipeProvider.has((ItemLike)block)).save(out, ResourceLocation.fromNamespaceAndPath((String)"gemforged", (String)(name + "_from_block")));
    }
}

