/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.entity;

import java.awt.Color;
import java.util.List;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.trique.gemforged.entity.GemforgedEntities;
import net.trique.gemforged.item.GemforgedItems;
import org.joml.Vector3f;

public class VerdantTotemEntity
extends Entity
implements ItemSupplier {
    private int lifeTicks;
    private Player owner;
    private ItemStack storedItem = ItemStack.EMPTY;
    private double originX;
    private double originZ;
    private double targetY;
    private double angle;

    public VerdantTotemEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.setNoGravity(true);
    }

    public VerdantTotemEntity(Level level, double x, double y, double z, Player owner) {
        this((EntityType)GemforgedEntities.VERDANT_TOTEM.get(), level);
        this.setPos(x, y, z);
        this.owner = owner;
        this.setNoGravity(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        ++this.lifeTicks;
        if (this.lifeTicks == 1) {
            this.originX = this.getX();
            this.originZ = this.getZ();
            this.targetY = this.getY() + 4.0;
            if (!this.level().isClientSide) {
                this.playSound(SoundEvents.ENCHANTMENT_TABLE_USE, 1.0f, 0.7f);
            }
        }
        double dy = this.getY() < this.targetY ? 0.05 : 0.0;
        double speed = 0.35;
        this.angle += speed;
        double radius = 0.8;
        double desiredX = this.originX + Math.cos(this.angle) * radius;
        double desiredZ = this.originZ + Math.sin(this.angle) * radius;
        double dx = (desiredX - this.getX()) * 0.4;
        double dz = (desiredZ - this.getZ()) * 0.4;
        this.setDeltaMovement(dx, dy, dz);
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setYRot(this.getYRot() + 8.0f);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.lifeTicks % 4 == 0) {
                server.sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(0.2f, 0.9f, 0.2f), 1.0f), this.getX(), this.getY() + 0.5, this.getZ(), 4, 0.35, 0.35, 0.35, 0.01);
            }
            for (int i = 0; i < 6; ++i) {
                double a = Math.PI * 2 * (double)i / 6.0;
                double px = this.getX() + Math.cos(a) * 1.5;
                double pz = this.getZ() + Math.sin(a) * 1.5;
                double py = this.getY() + 0.1 * Math.sin((double)(this.lifeTicks + i * 5) * 0.2);
                server.sendParticles((ParticleOptions)ParticleTypes.COMPOSTER, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (this.lifeTicks % 20 == 0) {
                AABB box = new AABB(this.getX() - 6.0, this.getY() - 6.0, this.getZ() - 6.0, this.getX() + 6.0, this.getY() + 6.0, this.getZ() + 6.0);
                List nearby = this.level().getEntitiesOfClass(LivingEntity.class, box);
                for (LivingEntity e : nearby) {
                    if (this.owner == null || !e.isAlliedTo((Entity)this.owner) && e != this.owner) continue;
                    e.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 60, 1, false, true, true));
                }
            }
        }
        if (this.lifeTicks == 200 && !this.level().isClientSide) {
            this.explodeAndDrop();
        }
    }

    private void explodeAndDrop() {
        int i;
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        for (i = 0; i < 4; ++i) {
            float pitch = 0.7f + (float)i * 0.1f;
            server.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.AMETHYST_BLOCK_RESONATE, SoundSource.PLAYERS, 4.0f, pitch);
            server.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.AMETHYST_CLUSTER_BREAK, SoundSource.PLAYERS, 4.0f, pitch);
            server.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.TOTEM_USE, SoundSource.PLAYERS, 4.0f, pitch);
        }
        server.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.BEACON_ACTIVATE, SoundSource.PLAYERS, 4.0f, 1.0f);
        for (i = 0; i < 120; ++i) {
            double spread = 1.0;
            server.sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(0.4f, 1.0f, 0.4f), 1.5f), this.getX(), this.getY(), this.getZ(), 1, this.random.nextGaussian() * spread, this.random.nextGaussian() * spread, this.random.nextGaussian() * spread, 0.04);
        }
        int[] colors = new int[]{3047689, 4896266, 7590410, 10347788, 14151429};
        int rings = 5;
        double maxRadius = 8.0;
        int pointsPerRing = 64;
        for (int ring = 0; ring < rings; ++ring) {
            double r = maxRadius / (double)rings * (double)(ring + 1);
            Color c = new Color(colors[ring]);
            Vector3f colorVec = new Vector3f((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
            for (int p = 0; p < pointsPerRing; ++p) {
                double a = Math.PI * 2 * (double)p / (double)pointsPerRing;
                double px = this.getX() + Math.cos(a) * r;
                double pz = this.getZ() + Math.sin(a) * r;
                double py = this.getY();
                this.spawnColoredSet(server, px, py, pz, colorVec);
                double vy = this.getY() + Math.sin(a) * r;
                double vz = this.getZ() + Math.cos(a) * r;
                double vx = this.getX();
                this.spawnColoredSet(server, vx, vy, vz, colorVec);
                double xx = this.getX() + Math.cos(a) * r;
                double yy = this.getY() + Math.sin(a) * r;
                double zz = this.getZ();
                this.spawnColoredSet(server, xx, yy, zz, colorVec);
            }
        }
        AABB area = new AABB(this.getX() - 6.0, this.getY() - 6.0, this.getZ() - 6.0, this.getX() + 6.0, this.getY() + 6.0, this.getZ() + 6.0);
        List list = server.getEntitiesOfClass(LivingEntity.class, area);
        for (LivingEntity e : list) {
            boolean isFriendly;
            boolean bl = isFriendly = this.owner != null && (e.isAlliedTo((Entity)this.owner) || e == this.owner);
            if (!isFriendly && !this.isUndead(e)) continue;
            e.addEffect(new MobEffectInstance(MobEffects.HEAL, 1, 4, false, true, true));
            e.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 1, false, true, true));
        }
        if (!this.storedItem.isEmpty()) {
            ItemStack drop = this.storedItem.copy();
            drop.setCount(1);
            int newDamage = drop.getDamageValue() + 1;
            if (newDamage < drop.getMaxDamage()) {
                drop.setDamageValue(newDamage);
            }
            server.addFreshEntity((Entity)new ItemEntity((Level)server, this.getX(), this.getY(), this.getZ(), drop));
        } else {
            server.addFreshEntity((Entity)new ItemEntity((Level)server, this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)GemforgedItems.VERDANT_TOTEM.get())));
        }
        this.discard();
    }

    private void spawnColoredSet(ServerLevel server, double x, double y, double z, Vector3f color) {
        server.sendParticles((ParticleOptions)new DustParticleOptions(color, 1.3f), x, y, z, 10, 0.0, 0.0, 0.0, 0.015);
        server.sendParticles((ParticleOptions)ParticleTypes.COMPOSTER, x, y, z, 8, 0.0, 0.0, 0.0, 0.015);
    }

    private boolean isUndead(LivingEntity e) {
        return e instanceof Zombie || e instanceof Skeleton || e instanceof WitherSkeleton || e instanceof Stray || e instanceof Drowned || e instanceof ZombifiedPiglin || e instanceof Husk || e instanceof Phantom || e instanceof WitherBoss || e instanceof Zoglin;
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
    }

    public ItemStack getItem() {
        return this.storedItem.isEmpty() ? new ItemStack((ItemLike)GemforgedItems.VERDANT_TOTEM.get()) : this.storedItem;
    }

    public void setItem(ItemStack stack) {
        this.storedItem = stack;
    }

    public void setOwner(Player player) {
        this.owner = player;
    }
}

