/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.item.gear;

import java.util.List;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.trique.gemforged.item.GemforgedItems;
import org.joml.Vector3f;

public class GravityHornItem
extends Item {
    private static final float RADIUS = 16.0f;
    private static final int COOLDOWN_TICKS = 600;
    private static final int USE_DURATION_TICKS = 20;
    private static final int LEVITATION_DURATION = 40;
    private static final int LEVITATION_AMPLIFIER = 4;
    private static final DustParticleOptions PURPLE = new DustParticleOptions(new Vector3f(0.3843f, 0.0784f, 0.4078f), 3.0f);
    private static final DustParticleOptions LILAC = new DustParticleOptions(new Vector3f(0.8196f, 0.1647f, 0.8588f), 3.0f);

    public GravityHornItem(Item.Properties props) {
        super(props.durability(250));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        if (!level.isClientSide) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 2.0f, 0.6f);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.AMETHYST_BLOCK_RESONATE, SoundSource.PLAYERS, 2.5f, 0.7f);
        }
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.TOOT_HORN;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 20;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        if (!level.isClientSide && user instanceof Player) {
            Player player = (Player)user;
            boolean creative = player.getAbilities().instabuild;
            ItemStack chargeResource = this.findChargeResource(player);
            if (creative || !chargeResource.isEmpty()) {
                this.triggerBurst((ServerLevel)level, player);
                if (!creative) {
                    chargeResource.shrink(1);
                    player.getCooldowns().addCooldown((Item)this, 600);
                    stack.hurtAndBreak(1, user, EquipmentSlot.MAINHAND);
                }
            }
        }
        return super.finishUsingItem(stack, level, user);
    }

    private ItemStack findChargeResource(Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack s = player.getInventory().getItem(i);
            if (!s.is((Item)GemforgedItems.GRAVITIUM.get())) continue;
            return s;
        }
        return ItemStack.EMPTY;
    }

    private void triggerBurst(ServerLevel level, Player player) {
        Vec3 c = player.position();
        level.playSound(null, c.x, c.y, c.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 3.0f, 0.5f);
        level.playSound(null, c.x, c.y, c.z, SoundEvents.BEACON_ACTIVATE, SoundSource.PLAYERS, 3.0f, 0.8f);
        level.playSound(null, c.x, c.y, c.z, SoundEvents.END_PORTAL_SPAWN, SoundSource.PLAYERS, 2.5f, 0.9f);
        this.spawnRing(level, c.add(0.0, 0.3, 0.0), 16.0f, 1200, PURPLE, 1.0f);
        this.spawnRing(level, c.add(0.0, 0.35, 0.0), 16.0f, 1200, LILAC, 1.0f);
        this.spawnStar(level, c.add(0.0, 0.5, 0.0), 12.0, 5, PURPLE);
        this.spawnStar(level, c.add(0.0, 0.5, 0.0), 12.0, 5, LILAC);
        AABB box = new AABB(c.x - 16.0, c.y - 16.0, c.z - 16.0, c.x + 16.0, c.y + 16.0, c.z + 16.0);
        List targets = level.getEntitiesOfClass(LivingEntity.class, box, e -> e.isAlive() && e != player);
        for (LivingEntity e2 : targets) {
            e2.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 40, 4, true, true));
        }
    }

    private void spawnRing(ServerLevel level, Vec3 center, float radius, int points, DustParticleOptions dust, float heightSpread) {
        double cx = center.x;
        double cy = center.y;
        double cz = center.z;
        for (int i = 0; i < points; ++i) {
            double a = Math.PI * 2 * (double)i / (double)points;
            double px = cx + (double)radius * Math.cos(a);
            double pz = cz + (double)radius * Math.sin(a);
            double py = cy + (level.random.nextDouble() - 0.5) * (double)heightSpread * 2.0;
            level.sendParticles((ParticleOptions)dust, px, py, pz, 2, 0.04, 0.04, 0.04, 0.01);
        }
    }

    private void spawnStar(ServerLevel level, Vec3 center, double radius, int points, DustParticleOptions dust) {
        int i;
        double cx = center.x;
        double cy = center.y;
        double cz = center.z;
        double[] xs = new double[points];
        double[] zs = new double[points];
        for (i = 0; i < points; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)points - 1.5707963267948966;
            xs[i] = cx + radius * Math.cos(angle);
            zs[i] = cz + radius * Math.sin(angle);
        }
        for (i = 0; i < points; ++i) {
            int j = (i + 2) % points;
            this.spawnLine(level, cy, xs[i], zs[i], xs[j], zs[j], dust);
        }
    }

    private void spawnLine(ServerLevel level, double cy, double x1, double z1, double x2, double z2, DustParticleOptions dust) {
        int steps = 100;
        for (int i = 0; i <= steps; ++i) {
            double t = (double)i / (double)steps;
            double px = x1 + (x2 - x1) * t;
            double pz = z1 + (z2 - z1) * t;
            level.sendParticles((ParticleOptions)dust, px, cy, pz, 2, 0.05, 0.05, 0.05, 0.01);
        }
    }
}

