/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.item.gear;

import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.trique.gemforged.item.GemforgedItems;
import org.joml.Vector3f;

public class ShadowstepDaggerItem
extends SwordItem {
    private static final String TAG_COMBO = "onyx_combo";
    private static final String TAG_LASTHIT = "onyx_last_hit";
    private static final int MAX_COMBO = 6;
    private static final int COMBO_TIMEOUT_TICKS = 60;
    private static final int COOLDOWN_TICKS = 600;
    private static final double TP_MIN = 2.0;
    private static final double TP_MAX = 3.0;
    private static final ResourceLocation MOD_DAMAGE_ID = ResourceLocation.parse((String)"gemforged:onyx_combo_damage");
    private static final ResourceLocation MOD_SPEED_ID = ResourceLocation.parse((String)"gemforged:onyx_combo_speed");
    private static final Vector3f SHADOW_PURPLE = new Vector3f(0.2627f, 0.1569f, 0.3843f);
    private static final Vector3f SHADOW_LIGHT = new Vector3f(0.4745f, 0.3294f, 0.6118f);

    public ShadowstepDaggerItem(Item.Properties props) {
        super((Tier)Tiers.DIAMOND, props.attributes(SwordItem.createAttributes((Tier)Tiers.DIAMOND, (int)2, (float)-2.0f)));
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!(attacker instanceof Player)) {
            return true;
        }
        Player player = (Player)attacker;
        Level level = player.level();
        if (level.isClientSide) {
            return true;
        }
        CustomData cd = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = cd.copyTag();
        long now = level.getGameTime();
        int combo = tag.getInt(TAG_COMBO);
        long last = tag.getLong(TAG_LASTHIT);
        if (combo > 0 && now - last > 60L) {
            combo = 0;
            this.removeComboModifiers(player);
        }
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            this.removeComboModifiers(player);
            return true;
        }
        if (combo == 0) {
            ItemStack nyxite = this.findChargeResource(player);
            boolean creative = player.getAbilities().instabuild;
            if (!creative && nyxite.isEmpty()) {
                return true;
            }
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (target.isAlive()) {
                this.tryTeleportAround((ServerLevel)level, sp, target);
                sp.lookAt(EntityAnchorArgument.Anchor.EYES, target.position());
            }
        }
        tag.putInt(TAG_COMBO, ++combo);
        tag.putLong(TAG_LASTHIT, now);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        if (combo == 1) {
            this.addComboModifiers(player);
        }
        if (combo >= 6) {
            boolean creative = player.getAbilities().instabuild;
            ItemStack nyxite = this.findChargeResource(player);
            if (creative || !nyxite.isEmpty()) {
                if (!creative) {
                    nyxite.shrink(1);
                }
                player.getCooldowns().addCooldown((Item)this, 600);
            }
            tag.putInt(TAG_COMBO, 0);
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            this.removeComboModifiers(player);
        }
        return true;
    }

    private ItemStack findChargeResource(Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack s = player.getInventory().getItem(i);
            if (!s.is((Item)GemforgedItems.NYXITE.get())) continue;
            return s;
        }
        return ItemStack.EMPTY;
    }

    private void addComboModifiers(Player player) {
        AttributeInstance dmg = player.getAttribute(Attributes.ATTACK_DAMAGE);
        AttributeInstance spd = player.getAttribute(Attributes.ATTACK_SPEED);
        if (dmg != null && dmg.getModifier(MOD_DAMAGE_ID) == null) {
            dmg.addTransientModifier(new AttributeModifier(MOD_DAMAGE_ID, 2.0, AttributeModifier.Operation.ADD_VALUE));
        }
        if (spd != null && spd.getModifier(MOD_SPEED_ID) == null) {
            spd.addTransientModifier(new AttributeModifier(MOD_SPEED_ID, 10.0, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    private void removeComboModifiers(Player player) {
        AttributeInstance dmg = player.getAttribute(Attributes.ATTACK_DAMAGE);
        AttributeInstance spd = player.getAttribute(Attributes.ATTACK_SPEED);
        if (dmg != null) {
            dmg.removeModifier(MOD_DAMAGE_ID);
        }
        if (spd != null) {
            spd.removeModifier(MOD_SPEED_ID);
        }
    }

    private void tryTeleportAround(ServerLevel level, ServerPlayer player, LivingEntity target) {
        Vec3 c = target.position();
        for (int i = 0; i < 10; ++i) {
            double a;
            double d = Mth.nextDouble((RandomSource)level.random, (double)2.0, (double)3.0);
            BlockPos guess = BlockPos.containing((double)(c.x + d * Math.cos(a = level.random.nextDouble() * Math.PI * 2.0)), (double)c.y, (double)(c.z + d * Math.sin(a)));
            BlockPos safe = this.findStandable(level, guess, 6);
            if (safe == null) continue;
            Vec3 from = player.position();
            this.spawnShadowSmoke(level, from.x, from.y + 1.0, from.z);
            this.playShadowTeleportSound(level, from.x, from.y, from.z);
            player.teleportTo(level, (double)safe.getX() + 0.5, (double)safe.getY(), (double)safe.getZ() + 0.5, player.getYRot(), player.getXRot());
            Vec3 to = player.position();
            this.spawnShadowSmoke(level, to.x, to.y + 1.0, to.z);
            this.playShadowTeleportSound(level, to.x, to.y, to.z);
            return;
        }
    }

    private void spawnShadowSmoke(ServerLevel level, double x, double y, double z) {
        level.sendParticles((ParticleOptions)new DustParticleOptions(SHADOW_PURPLE, 1.5f), x, y, z, 20, 0.6, 0.25, 0.6, 0.02);
        level.sendParticles((ParticleOptions)new DustParticleOptions(SHADOW_LIGHT, 1.5f), x, y, z, 20, 0.6, 0.25, 0.6, 0.02);
        level.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, x, y, z, 20, 0.6, 0.25, 0.6, 0.02);
        level.sendParticles((ParticleOptions)ParticleTypes.ASH, x, y, z, 10, 0.5, 0.2, 0.5, 0.01);
    }

    private void playShadowTeleportSound(ServerLevel level, double x, double y, double z) {
        level.playSound(null, x, y, z, SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 0.6f + level.random.nextFloat() * 0.2f);
        level.playSound(null, x, y, z, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 0.8f, 0.9f + level.random.nextFloat() * 0.1f);
    }

    private BlockPos findStandable(ServerLevel lvl, BlockPos pos, int vRange) {
        BlockPos.MutableBlockPos m = pos.mutable();
        for (int dy = 0; dy <= vRange; ++dy) {
            if (this.isStandable(lvl, (BlockPos)m.set(pos.getX(), pos.getY() + dy, pos.getZ()))) {
                return m.immutable();
            }
            if (!this.isStandable(lvl, (BlockPos)m.set(pos.getX(), pos.getY() - dy, pos.getZ()))) continue;
            return m.immutable();
        }
        return null;
    }

    private boolean isStandable(ServerLevel lvl, BlockPos pos) {
        BlockPos below = pos.below();
        BlockState sBelow = lvl.getBlockState(below);
        boolean solidBelow = !sBelow.getCollisionShape((BlockGetter)lvl, below).isEmpty();
        boolean airFeet = lvl.isEmptyBlock(pos);
        boolean airHead = lvl.isEmptyBlock(pos.above());
        return solidBelow && airFeet && airHead;
    }
}

