/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.item.gear;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.trique.gemforged.entity.ThunderPrismEntity;
import net.trique.gemforged.item.GemforgedItems;

public class ThunderPrismItem
extends Item {
    public ThunderPrismItem(Item.Properties props) {
        super(props.durability(250));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            if (player.getCooldowns().isOnCooldown((Item)this)) {
                return InteractionResultHolder.fail((Object)stack);
            }
            boolean creative = player.getAbilities().instabuild;
            ItemStack chargeResource = this.findChargeResource(player);
            if (creative || !chargeResource.isEmpty()) {
                level.playSound(null, player.blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 0.9f, 0.6f + level.random.nextFloat() * 0.2f);
                ItemStack prismStack = stack.copy();
                prismStack.setCount(1);
                ThunderPrismEntity prism = new ThunderPrismEntity(level, player.getX(), player.getY() + 1.0, player.getZ(), player);
                prism.setItem(prismStack);
                level.addFreshEntity((Entity)prism);
                player.getCooldowns().addCooldown((Item)this, 800);
                if (!creative) {
                    chargeResource.shrink(1);
                    stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                }
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    private ItemStack findChargeResource(Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack s = player.getInventory().getItem(i);
            if (!s.is((Item)GemforgedItems.PRISMYTE.get())) continue;
            return s;
        }
        return ItemStack.EMPTY;
    }
}

