/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.worldgen;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.trique.gemforged.block.GemforgedBlocks;

public class GemforgedConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> RANDOM_GEM_VEIN_KEY = GemforgedConfiguredFeatures.registerKey("random_gem_vein");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> randomGemTargets = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)GemforgedBlocks.RANDOM_GEM_VEIN.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)GemforgedBlocks.DEEPSLATE_RANDOM_GEM_VEIN.get()).defaultBlockState()));
        GemforgedConfiguredFeatures.register(context, RANDOM_GEM_VEIN_KEY, Feature.ORE, new OreConfiguration(randomGemTargets, 5));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gemforged", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

